/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.websocket;

import android.text.TextUtils;
import com.tds.common.websocket.WebSocketClient;
import com.tds.common.websocket.WebSocketEventListener;
import com.tds.common.websocket.WebSocketMessage;
import com.tds.common.websocket.WebSocketStateListener;
import com.tds.common.websocket.util.LogUtil;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class TDSWebSocketService
implements WebSocketEventListener {
    public static final int STATE_OPEN = 1;
    public static final int STATE_CLOSED = 2;
    public static final int STATE_CLOSING = 3;
    private final int EVENT_OPEN = 1;
    private final int EVENT_CLOSE = 2;
    private final int EVENT_MESSAGE = 3;
    private final int EVENT_ERROR = 4;
    private static AtomicInteger tryTimes = new AtomicInteger(1);
    private static final int TRY_MAX_TIMES = 60;
    private static volatile TDSWebSocketService instance;
    private static volatile boolean hasOffLine;
    private volatile WebSocketClient webSocketClient;
    private volatile boolean isRetryInSleep = false;
    private volatile boolean isConnecting = false;
    private String destUrl;
    private WebSocketConfig webSocketConfig;
    private HashMap<WebSocketMessage.Type, WeakReference<WebSocketEventListener>> messageListenerMap = new HashMap();
    private List<WebSocketStateListener> stateListenerList = new ArrayList<WebSocketStateListener>();

    private TDSWebSocketService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TDSWebSocketService getInstance() {
        if (instance != null) return instance;
        Class<TDSWebSocketService> clazz = TDSWebSocketService.class;
        synchronized (TDSWebSocketService.class) {
            if (instance != null) return instance;
            instance = new TDSWebSocketService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void setDestUrl(String dest_url, WebSocketConfig webSocketConfig) {
        if (TextUtils.isEmpty((CharSequence)dest_url) || webSocketConfig == null) {
            return;
        }
        if (dest_url.equals(this.destUrl) && webSocketConfig.isEqual(this.webSocketConfig)) {
            return;
        }
        this.reset();
        this.webSocketConfig = webSocketConfig;
        this.webSocketClient = new WebSocketClient(URI.create(dest_url), webSocketConfig, (WebSocketEventListener)this);
        hasOffLine = false;
        this.destUrl = dest_url;
        this.webSocketClient.connect();
        this.isConnecting = true;
    }

    public synchronized void checkConnection() {
        if (TextUtils.isEmpty((CharSequence)this.destUrl) || this.isConnecting || this.webSocketConfig == null) {
            return;
        }
        hasOffLine = false;
        if (this.webSocketClient == null || !this.webSocketClient.isOpen()) {
            this.clearWebSocketClient();
            this.webSocketClient = new WebSocketClient(URI.create(this.destUrl), this.webSocketConfig, (WebSocketEventListener)this);
            this.webSocketClient.connect();
            this.isConnecting = true;
        }
    }

    public synchronized void disconnect() {
        hasOffLine = true;
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            this.webSocketClient.close();
        }
        this.clearWebSocketClient();
    }

    public synchronized void reset() {
        this.disconnect();
        this.destUrl = null;
    }

    public void registerMessageListener(WebSocketMessage.Type type, WebSocketEventListener listener) {
        this.messageListenerMap.put(type, new WeakReference<WebSocketEventListener>(listener));
    }

    public void unregisterMessageListener(WebSocketMessage.Type type) {
        this.messageListenerMap.remove((Object)type);
    }

    public void addConnectionStateListener(WebSocketStateListener listener) {
        if (listener == null) {
            return;
        }
        if (this.getConnectionState() == 1) {
            listener.onOpen();
        } else if (!(this.getConnectionState() != 2 || this.isRetryInSleep || this.isConnecting || TextUtils.isEmpty((CharSequence)this.destUrl))) {
            listener.onClose();
        } else {
            this.stateListenerList.add(listener);
        }
    }

    @Override
    public void onOpen() {
        LogUtil.logD("receive open = ");
        this.isConnecting = false;
        tryTimes.set(1);
        this.dispatchEvent(1, new Object[0]);
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        this.isConnecting = false;
        this.clearWebSocketClient();
        this.dispatchEvent(2, code, reason, remote);
    }

    public synchronized void retryConnectWithDelay() {
        if (TextUtils.isEmpty((CharSequence)this.destUrl)) {
            return;
        }
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            return;
        }
        if (!(hasOffLine || this.isRetryInSleep || this.isConnecting)) {
            LogUtil.logE(" websocket reconnect after close wait " + tryTimes + "s in thread " + Thread.currentThread().getName());
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        tryTimes.incrementAndGet();
                        TDSWebSocketService.this.isRetryInSleep = true;
                        int delay = (int)((Math.random() + 0.1) * (double)(tryTimes.get() > 60 ? 60 : tryTimes.intValue()) * 5000.0);
                        Thread.sleep(delay);
                        if (!(hasOffLine || TDSWebSocketService.this.webSocketClient != null && (TDSWebSocketService.this.webSocketClient.isOpen() || TDSWebSocketService.this.isConnecting))) {
                            if (TextUtils.isEmpty((CharSequence)TDSWebSocketService.this.destUrl) || TDSWebSocketService.this.webSocketConfig == null) {
                                return;
                            }
                            TDSWebSocketService.this.webSocketClient = new WebSocketClient(URI.create(TDSWebSocketService.this.destUrl), TDSWebSocketService.this.webSocketConfig, (WebSocketEventListener)instance);
                            TDSWebSocketService.this.webSocketClient.connect();
                            TDSWebSocketService.this.isConnecting = true;
                            LogUtil.logD(" websocket reconnect after close");
                        }
                        TDSWebSocketService.this.isRetryInSleep = false;
                    }
                    catch (Throwable e1) {
                        TDSWebSocketService.this.isRetryInSleep = false;
                        LogUtil.logE(" websocket reconnect fail error =  " + e1.getMessage());
                    }
                }
            });
            thread.setName("webSocketReTryConnect-" + System.currentTimeMillis() / 1000L);
            thread.start();
        }
    }

    @Override
    public void onMessage(String msg) {
        LogUtil.logD("receive msg = " + msg);
        WebSocketMessage.Type type = WebSocketMessage.getMessageType(msg);
        WeakReference<WebSocketEventListener> listenerWeakReference = this.messageListenerMap.get((Object)type);
        if (listenerWeakReference != null && listenerWeakReference.get() != null) {
            ((WebSocketEventListener)listenerWeakReference.get()).onMessage(msg);
        }
    }

    @Override
    public void onError(Exception e) {
        this.isConnecting = false;
        LogUtil.logE(" webSocketService onError offline = " + hasOffLine);
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            this.webSocketClient.close();
        }
        this.dispatchEvent(4, e);
    }

    private void clearWebSocketClient() {
        if (this.webSocketClient != null) {
            this.webSocketClient.removeEventListener();
            try {
                this.webSocketClient.close();
            }
            catch (Throwable e) {
                LogUtil.logE("clearWebSocketClient error = " + e.getMessage());
            }
            this.webSocketClient = null;
        }
    }

    private void dispatchEvent(int event, Object ... args) {
        Set<WebSocketMessage.Type> iterable = this.messageListenerMap.keySet();
        for (WebSocketMessage.Type type : iterable) {
            WebSocketEventListener listener;
            WeakReference<WebSocketEventListener> listenerWeakReference;
            if (this.messageListenerMap.get((Object)type) == null || (listenerWeakReference = this.messageListenerMap.get((Object)type)) == null || (listener = (WebSocketEventListener)listenerWeakReference.get()) == null) continue;
            switch (event) {
                case 1: {
                    listener.onOpen();
                    break;
                }
                case 2: {
                    listener.onClose((Integer)args[0], (String)args[1], (Boolean)args[2]);
                    break;
                }
                case 4: {
                    listener.onError((Exception)args[0]);
                }
            }
        }
        if (event == 1 || event == 4) {
            for (WebSocketStateListener listener : this.stateListenerList) {
                if (listener != null) {
                    if (event == 1) {
                        listener.onOpen();
                    } else {
                        listener.onError("");
                    }
                }
                this.stateListenerList.clear();
            }
        }
    }

    public int getConnectionState() {
        if (this.webSocketClient != null) {
            if (this.webSocketClient.isOpen()) {
                return 1;
            }
            if (this.webSocketClient.isClosed()) {
                return 2;
            }
            if (this.webSocketClient.isClosing()) {
                return 3;
            }
        }
        return 2;
    }

    public void sendMessage(String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg) && this.webSocketClient != null && this.webSocketClient.isOpen()) {
            this.webSocketClient.send(msg);
        }
    }

    static {
        hasOffLine = false;
    }

    public static class WebSocketConfigBuilder {
        int connectionTimeout = 45;
        Map<String, String> heads;

        public static WebSocketConfigBuilder getBuilder() {
            return new WebSocketConfigBuilder();
        }

        public WebSocketConfigBuilder connectTimeOut(int timeout) {
            this.connectionTimeout = timeout;
            return this;
        }

        public WebSocketConfigBuilder heads(Map<String, String> heads) {
            this.heads = heads;
            return this;
        }

        public WebSocketConfig build() {
            return new WebSocketConfig(this.connectionTimeout, this.heads);
        }
    }

    public static class WebSocketConfig {
        int connectionTimeout;
        public Map<String, String> heads;

        private WebSocketConfig(int timeout, Map<String, String> heads) {
            this.connectionTimeout = timeout;
            this.heads = heads;
        }

        public boolean isEqual(WebSocketConfig config) {
            if (config == null) {
                return false;
            }
            if (config.connectionTimeout == this.connectionTimeout) {
                if (this.heads == config.heads) {
                    return true;
                }
                if (this.heads != null && config.heads != null) {
                    if (this.heads.size() != config.heads.size()) {
                        return false;
                    }
                    if (this.heads.size() > 0) {
                        Set<String> keys = this.heads.keySet();
                        for (String key : keys) {
                            if (Objects.equals(this.heads.get(key), config.heads.get(key))) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

