/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.LruCache;
import com.tds.common.widgets.image.ImageUtil;

class MemCache {
    private final LruCache<String, Bitmap> lruCache;

    MemCache(Context context) {
        int memCacheSize = ImageUtil.calculateMemoryCacheSize(context);
        this.lruCache = new LruCache<String, Bitmap>(memCacheSize){

            protected int sizeOf(String key, Bitmap value) {
                return ImageUtil.getBitmapBytes(value);
            }

            protected void entryRemoved(boolean evicted, String key, Bitmap oldValue, Bitmap newValue) {
                super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
            }

            protected Bitmap create(String key) {
                return (Bitmap)super.create((Object)key);
            }
        };
    }

    Bitmap get(String key) {
        return (Bitmap)this.lruCache.get((Object)key);
    }

    void put(String key, Bitmap bitmap) {
        this.lruCache.put((Object)key, (Object)bitmap);
    }
}

