/*
 * Decompiled with CFR 0.152.
 */
package tds.com.google.android.material.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import tds.androidx.annotation.Dimension;
import tds.androidx.annotation.NonNull;
import tds.androidx.annotation.Nullable;
import tds.androidx.annotation.RestrictTo;
import tds.androidx.core.view.ViewCompat;
import tds.androidx.core.view.WindowInsetsCompat;
import tds.com.google.android.material.internal.ViewOverlayApi14;
import tds.com.google.android.material.internal.ViewOverlayApi18;
import tds.com.google.android.material.internal.ViewOverlayImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ViewUtils {
    private ViewUtils() {
    }

    public static PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    public static boolean isLayoutRtl(View view) {
        return ViewCompat.getLayoutDirection(view) == 1;
    }

    public static float dpToPx(@NonNull Context context, @Dimension(unit=0) int dp) {
        Resources r = context.getResources();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    public static void requestFocusAndShowKeyboard(final @NonNull View view) {
        view.requestFocus();
        view.post(new Runnable(){

            @Override
            public void run() {
                InputMethodManager inputMethodManager = (InputMethodManager)view.getContext().getSystemService("input_method");
                inputMethodManager.showSoftInput(view, 1);
            }
        });
    }

    public static void doOnApplyWindowInsets(@NonNull View view, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        ViewUtils.doOnApplyWindowInsets(view, attrs, defStyleAttr, defStyleRes, null);
    }

    public static void doOnApplyWindowInsets(@NonNull View view, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes, final @Nullable OnApplyWindowInsetsListener listener) {
        boolean paddingBottomSystemWindowInsets = false;
        boolean paddingLeftSystemWindowInsets = false;
        boolean paddingRightSystemWindowInsets = false;
        ViewUtils.doOnApplyWindowInsets(view, new OnApplyWindowInsetsListener(){

            @Override
            @NonNull
            public WindowInsetsCompat onApplyWindowInsets(View view, @NonNull WindowInsetsCompat insets, @NonNull RelativePadding initialPadding) {
                boolean isRtl = ViewUtils.isLayoutRtl(view);
                initialPadding.applyToView(view);
                return listener != null ? listener.onApplyWindowInsets(view, insets, initialPadding) : insets;
            }
        });
    }

    public static void doOnApplyWindowInsets(@NonNull View view, final @NonNull OnApplyWindowInsetsListener listener) {
        final RelativePadding initialPadding = new RelativePadding(ViewCompat.getPaddingStart(view), view.getPaddingTop(), ViewCompat.getPaddingEnd(view), view.getPaddingBottom());
        ViewCompat.setOnApplyWindowInsetsListener(view, new tds.androidx.core.view.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat insets) {
                return listener.onApplyWindowInsets(view, insets, new RelativePadding(initialPadding));
            }
        });
        ViewUtils.requestApplyInsetsWhenAttached(view);
    }

    public static void requestApplyInsetsWhenAttached(@NonNull View view) {
        if (ViewCompat.isAttachedToWindow(view)) {
            ViewCompat.requestApplyInsets(view);
        } else {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(@NonNull View v) {
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewCompat.requestApplyInsets(v);
                }

                public void onViewDetachedFromWindow(View v) {
                }
            });
        }
    }

    public static float getParentAbsoluteElevation(@NonNull View view) {
        float absoluteElevation = 0.0f;
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof View) {
            absoluteElevation += ViewCompat.getElevation((View)viewParent);
            viewParent = viewParent.getParent();
        }
        return absoluteElevation;
    }

    @Nullable
    public static ViewOverlayImpl getOverlay(@Nullable View view) {
        if (view == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return new ViewOverlayApi18(view);
        }
        return ViewOverlayApi14.createFrom(view);
    }

    @Nullable
    public static ViewGroup getContentView(@Nullable View view) {
        if (view == null) {
            return null;
        }
        View rootView = view.getRootView();
        ViewGroup contentView = (ViewGroup)rootView.findViewById(0x1020002);
        if (contentView != null) {
            return contentView;
        }
        if (rootView != view && rootView instanceof ViewGroup) {
            return (ViewGroup)rootView;
        }
        return null;
    }

    @Nullable
    public static ViewOverlayImpl getContentViewOverlay(@NonNull View view) {
        return ViewUtils.getOverlay((View)ViewUtils.getContentView(view));
    }

    public static void addOnGlobalLayoutListener(@Nullable View view, @NonNull ViewTreeObserver.OnGlobalLayoutListener victim) {
        if (view != null) {
            view.getViewTreeObserver().addOnGlobalLayoutListener(victim);
        }
    }

    public static void removeOnGlobalLayoutListener(@Nullable View view, @NonNull ViewTreeObserver.OnGlobalLayoutListener victim) {
        if (view != null) {
            ViewUtils.removeOnGlobalLayoutListener(view.getViewTreeObserver(), victim);
        }
    }

    public static void removeOnGlobalLayoutListener(@NonNull ViewTreeObserver viewTreeObserver, @NonNull ViewTreeObserver.OnGlobalLayoutListener victim) {
        if (Build.VERSION.SDK_INT >= 16) {
            viewTreeObserver.removeOnGlobalLayoutListener(victim);
        } else {
            viewTreeObserver.removeGlobalOnLayoutListener(victim);
        }
    }

    public static class RelativePadding {
        public int start;
        public int top;
        public int end;
        public int bottom;

        public RelativePadding(int start, int top, int end, int bottom) {
            this.start = start;
            this.top = top;
            this.end = end;
            this.bottom = bottom;
        }

        public RelativePadding(@NonNull RelativePadding other) {
            this.start = other.start;
            this.top = other.top;
            this.end = other.end;
            this.bottom = other.bottom;
        }

        public void applyToView(View view) {
            ViewCompat.setPaddingRelative(view, this.start, this.top, this.end, this.bottom);
        }
    }

    public static interface OnApplyWindowInsetsListener {
        public WindowInsetsCompat onApplyWindowInsets(View var1, WindowInsetsCompat var2, RelativePadding var3);
    }
}

