/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.utils;

import android.app.Activity;
import android.text.TextUtils;
import com.tapsdk.antiaddiction.skynet.exceptions.AntiServerException;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddiction.utils.Utils;
import com.tapsdk.antiaddictionui.utils.ActivityUtils;
import com.tapsdk.antiaddictionui.widget.AntiToastManager;

public class ToastUtils {
    public static void safeToast(Activity activity, String msg) {
        if (ActivityUtils.isActivityAlive(activity)) {
            AntiToastManager.instance().show(activity, msg, 0);
        }
    }

    public static void safeToastError(Activity activity, Throwable throwable) {
        if (ActivityUtils.isActivityAlive(activity)) {
            AntiToastManager.instance().show(activity, Utils.parseErrorMessage((Throwable)throwable), 0);
        }
    }

    public static String fetchErrorMessage(Throwable e, String defaultMsg) {
        String errorMsg = defaultMsg;
        if (e instanceof AntiServerException) {
            AntiServerException exception = (AntiServerException)e;
            if (!TextUtils.isEmpty((CharSequence)exception.msg) && !"Server down".equals(exception.msg)) {
                errorMsg = exception.msg;
                AntiAddictionLogger.e((String)("real name failed:" + errorMsg));
            }
        } else if (e.getMessage() != null && e.getMessage().contains("Unable to resolve host")) {
            errorMsg = "\u7f51\u7edc\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u60c5\u51b5";
        }
        return errorMsg;
    }
}

