/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.wrapper;

import android.app.Activity;
import android.util.Log;
import com.tapsdk.antiaddiction.Callback;
import com.tapsdk.antiaddiction.Config;
import com.tapsdk.antiaddiction.entities.response.CheckPayResult;
import com.tapsdk.antiaddiction.entities.response.SubmitPayResult;
import com.tapsdk.antiaddictionui.AntiAddictionUICallback;
import com.tapsdk.antiaddictionui.AntiAddictionUIKit;
import com.tapsdk.antiaddictionui.wrapper.TDSAntiAddictionUIService;
import com.tds.common.bridge.BridgeCallback;
import com.tds.common.bridge.utils.BridgeJsonHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TDSAntiAddictionUIServiceImpl
implements TDSAntiAddictionUIService {
    @Override
    public void initImpl(Activity activity, String clientID, boolean useTapLogin, boolean showSwitchAccount, final BridgeCallback callback) {
        this.print(String.format(Locale.CHINA, "\u6267\u884c initImpl clientId: %s  useTapLogin:%b  showSwitchAccount: %b", clientID, useTapLogin, showSwitchAccount));
        Config.Builder configBuilder = new Config.Builder();
        configBuilder.withClientId(clientID).enableTapLogin(useTapLogin).showSwitchAccount(showSwitchAccount);
        AntiAddictionUIKit.init(activity, configBuilder.build(), new AntiAddictionUICallback(){

            @Override
            public void onCallback(int code, Map<String, Object> extras) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("code", code);
                params.put("msg", extras == null ? "" : extras);
                callback.onResult(BridgeJsonHelper.object2JsonString(params));
                TDSAntiAddictionUIServiceImpl.this.print(BridgeJsonHelper.object2JsonString(params));
            }
        });
    }

    @Override
    public void enterGame() {
        this.print("\u6267\u884c enterGame");
        AntiAddictionUIKit.enterGame();
    }

    @Override
    public void leaveGame() {
        this.print("\u6267\u884c leaveGame");
        AntiAddictionUIKit.leaveGame();
    }

    @Override
    public void startup(Activity activity, String userID) {
        this.print("\u6267\u884c startup\uff1a " + userID);
        AntiAddictionUIKit.startup(activity, userID);
    }

    @Override
    public void exit() {
        this.print("\u6267\u884c exit");
        AntiAddictionUIKit.exit();
    }

    @Override
    public String getAgeRange() {
        String numStr = AntiAddictionUIKit.getAgeRange() + "";
        this.print("\u6267\u884c getAgeRange\uff1a" + numStr);
        return numStr;
    }

    @Override
    public String getRemainingTimeInMinutes() {
        String numStr = AntiAddictionUIKit.getRemainingTimeInMinutes() + "";
        this.print("\u6267\u884c getRemainingTimeInMinutes\uff1a" + numStr);
        return numStr;
    }

    @Override
    public String getRemainingTime() {
        String numStr = AntiAddictionUIKit.getRemainingTime() + "";
        this.print("\u6267\u884c getRemainingTime\uff1a" + numStr);
        return numStr;
    }

    @Override
    public void checkPayLimit(Activity activity, int amount, final BridgeCallback callback) {
        AntiAddictionUIKit.checkPayLimit(activity, amount, new com.tapsdk.antiaddictionui.Callback<CheckPayResult>(){

            @Override
            public void onSuccess(CheckPayResult result) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("code", result.status ? 1 : 0);
                params.put("msg", result.description);
                callback.onResult(BridgeJsonHelper.object2JsonString(params));
                TDSAntiAddictionUIServiceImpl.this.print(BridgeJsonHelper.object2JsonString(params));
            }

            @Override
            public void onError(Throwable throwable) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("code", -1);
                params.put("msg", throwable.getMessage());
                callback.onResult(BridgeJsonHelper.object2JsonString(params));
                TDSAntiAddictionUIServiceImpl.this.print(BridgeJsonHelper.object2JsonString(params));
            }
        });
    }

    @Override
    public void submitPayResult(int amount, final BridgeCallback callback) {
        AntiAddictionUIKit.submitPayResult(amount, new Callback<SubmitPayResult>(){

            public void onSuccess(SubmitPayResult result) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("code", 1);
                params.put("msg", "success");
                callback.onResult(BridgeJsonHelper.object2JsonString(params));
                TDSAntiAddictionUIServiceImpl.this.print(BridgeJsonHelper.object2JsonString(params));
            }

            public void onError(Throwable throwable) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("code", 0);
                params.put("msg", throwable.getMessage());
                callback.onResult(BridgeJsonHelper.object2JsonString(params));
                TDSAntiAddictionUIServiceImpl.this.print(BridgeJsonHelper.object2JsonString(params));
            }
        });
    }

    @Override
    public String currentToken() {
        return AntiAddictionUIKit.currentToken();
    }

    private void print(String msg) {
        Log.i((String)"TDS Anti Log:", (String)msg);
    }
}

