/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.models;

import android.content.Context;
import com.tapsdk.antiaddiction.entities.CommonConfig;
import com.tapsdk.antiaddiction.reactor.Observable;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.rest.api.AntiAddictionApi;
import com.tapsdk.antiaddiction.settings.AntiAddictionSettings;
import com.tapsdk.antiaddiction.skynet.Skynet;
import com.tapsdk.antiaddiction.skynet.retrofit2.Call;
import com.tapsdk.antiaddiction.skynet.retrofit2.Response;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;

public class ConfigModel {
    private CommonConfig commonConfig;

    public CommonConfig fetchCommonConfig(String clientId) {
        if (this.commonConfig != null && this.commonConfig.uiConfig != null) {
            return this.commonConfig;
        }
        AntiAddictionApi antiAddictionApi = Skynet.getService(Skynet.RETROFIT_FOR_ANTI_ADDICTION, AntiAddictionApi.class);
        try {
            Call<CommonConfig> call = antiAddictionApi.fetchConfig(clientId);
            Response<CommonConfig> response = call.execute();
            if (response.isSuccessful()) {
                this.commonConfig = response.body();
                return this.commonConfig;
            }
        }
        catch (Exception e) {
            AntiAddictionLogger.printStackTrace(e);
        }
        return null;
    }

    public boolean fetchAndSetupCommonConfig(Context context, String clientId) {
        CommonConfig result = this.commonConfig;
        if (result == null || result.uiConfig == null) {
            result = this.fetchCommonConfig(clientId);
        }
        if (result == null) {
            result = AntiAddictionSettings.getInstance().getCommonDefaultConfig(context);
        }
        AntiAddictionSettings.getInstance().setCommonConfig(result);
        this.commonConfig = result;
        return result != null;
    }

    public Observable<Boolean> fetchAndSetupCommonConfigAsync(final Context context, final String gameIdentifier) {
        return Observable.create(new Observable.OnSubscribe<Boolean>(){

            @Override
            public void call(Subscriber<? super Boolean> subscriber) {
                subscriber.onNext((Boolean)ConfigModel.this.fetchAndSetupCommonConfig(context, gameIdentifier));
            }
        });
    }
}

