/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.models;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.tapsdk.antiaddiction.entities.request.IdentifyManuallyRequestParams;
import com.tapsdk.antiaddiction.entities.response.IdentifyState;
import com.tapsdk.antiaddiction.reactor.Observable;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.rest.api.IdentificationApi;
import com.tapsdk.antiaddiction.rest.utils.RSAEncryption;
import com.tapsdk.antiaddiction.settings.AntiAddictionSettings;
import com.tapsdk.antiaddiction.skynet.Skynet;
import com.tapsdk.antiaddiction.skynet.exceptions.AntiServerException;
import com.tds.gson.Gson;
import com.tds.gson.GsonBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class IdentifyModel {
    private int[] AGE_LIMIT = new int[]{0, 8, 16, 18};
    private Gson gson = new GsonBuilder().create();
    private static String IDENTIFY_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1pM6yfulomBTXWKiQT5gK9fY4hq11Kv8D+ewum25oPGReuEn6dez7ogA8bEyQlnYYUoEp5cxYPBbIxJFy7q1qzQhTFphuFzoC1x7DieTvfZbh+b60psEottrCD8M0Pa3h44pzyIp5U5WRpxRcQ9iULolGLHZXJr9nW6bpOsyEIFG5tQ7qCBj8HSFoNBKZH+5Cwh3j5cjmyg55WdJTimg9ysbbwZHYmI+TFPuGo/ckHT6j4TQLCmmxI8Qf5pycn3/qJWFhjx/y8zaxgn2hgxbma8hyyGRCMnhM5tISYQv4zlQF+5RashvKa2zv+FHA5DALzIsGXONeTxk6TSBalX5gQIDAQAB";

    public static void switchIdentifyPublicKey(String newKey) {
        IDENTIFY_PUBLIC_KEY = newKey;
    }

    public Observable<IdentifyState> inquireIdentifyState(String clientId, String userId) {
        IdentificationApi api = Skynet.getService(Skynet.RETROFIT_FOR_IDENTIFY, IdentificationApi.class);
        return api.inquireIdentifyState(clientId, userId);
    }

    public Observable<IdentifyState> identifyUserManually(String clientId, String userIdentifier, String name, String idCard) {
        IdentificationApi api = Skynet.getService(Skynet.RETROFIT_FOR_IDENTIFY, IdentificationApi.class);
        IdentifyManuallyRequestParams identifyRequestParams = new IdentifyManuallyRequestParams();
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("name", name);
        requestParams.put("id_card", idCard);
        try {
            identifyRequestParams.data = new String(Base64.encode((byte[])RSAEncryption.encrypt(this.gson.toJson(requestParams), RSAEncryption.getPublicKey(IDENTIFY_PUBLIC_KEY)), (int)0), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return api.identifyUserManual(clientId, userIdentifier, identifyRequestParams);
    }

    public static boolean checkIdentify(String identify) {
        if (identify == null || "".equals(identify) || identify.length() != 18) {
            return false;
        }
        String regularExpression = "(^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$)";
        boolean matches = identify.matches(regularExpression);
        if (matches) {
            try {
                char[] charArray = identify.toCharArray();
                int[] idCardWi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
                String[] idCardY = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
                int sum = 0;
                for (int i = 0; i < idCardWi.length; ++i) {
                    int current = Integer.parseInt(String.valueOf(charArray[i]));
                    int count = current * idCardWi[i];
                    sum += count;
                }
                char idCardLast = charArray[17];
                int idCardMod = sum % 11;
                return idCardY[idCardMod].toUpperCase().equals(String.valueOf(idCardLast).toUpperCase());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static int getAgeByDate(Date birthday) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.getTimeInMillis() - birthday.getTime() < 0L) {
            return 0;
        }
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.setTime(birthday);
        int yearBirthday = calendar.get(1);
        int monthBirthday = calendar.get(2);
        int dayOfMonthBirthday = calendar.get(5);
        int age = year - yearBirthday;
        if (month == monthBirthday && day < dayOfMonthBirthday || month < monthBirthday) {
            --age;
        }
        return age;
    }

    public static int getAgeFromIdentify(String identify) {
        String dateStr = identify.length() == 15 ? "19" + identify.substring(6, 12) : identify.substring(6, 14);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            Date birthday = simpleDateFormat.parse(dateStr);
            if (null != birthday) {
                return IdentifyModel.getAgeByDate(birthday);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int getAgeLimit(int age) {
        if (age < 0) {
            return -1;
        }
        for (int i = 1; i < this.AGE_LIMIT.length; ++i) {
            if (age >= this.AGE_LIMIT[i]) continue;
            return this.AGE_LIMIT[i - 1];
        }
        return 18;
    }

    public Observable<IdentifyState> identifyUserLocal(final Context context, final String userIdentifier, final String name, final String idCard) {
        return Observable.create(new Observable.OnSubscribe<IdentifyState>(){

            @Override
            public void call(Subscriber<? super IdentifyState> subscriber) {
                boolean identityCheckResult = IdentifyModel.checkIdentify(idCard);
                if (!identityCheckResult) {
                    subscriber.onError(new AntiServerException(500, "\u8eab\u4efd\u8bc1\u53f7\u7801\u975e\u6cd5", 500));
                    return;
                }
                if (name.length() > 0) {
                    int age = IdentifyModel.getAgeFromIdentify(idCard);
                    if (age > 0) {
                        IdentifyState identifyState = new IdentifyState();
                        identifyState.identifyState = 0;
                        identifyState.ageLimit = IdentifyModel.this.getAgeLimit(age);
                        identifyState.hasAuthRecord = false;
                        identifyState.antiAddictionToken = "standalone_anti_addiction_token";
                        AntiAddictionSettings.getInstance().cacheUserInfo(context, userIdentifier, identifyState.antiAddictionToken, identifyState.ageLimit);
                        String identifyCacheData = "";
                        HashMap<String, String> requestParams = new HashMap<String, String>();
                        requestParams.put("name", name);
                        requestParams.put("id_card", idCard);
                        try {
                            identifyCacheData = new String(Base64.encode((byte[])RSAEncryption.encrypt(IdentifyModel.this.gson.toJson(requestParams), RSAEncryption.getPublicKey(IDENTIFY_PUBLIC_KEY)), (int)0), "UTF-8");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (!identifyCacheData.isEmpty()) {
                            AntiAddictionSettings.getInstance().cacheAuthInputInfo(context, userIdentifier, identifyCacheData);
                        }
                        subscriber.onNext(identifyState);
                        subscriber.onCompleted();
                    } else {
                        subscriber.onError(new Throwable("\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f"));
                    }
                } else {
                    subscriber.onError(new Throwable("\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f"));
                }
            }
        });
    }

    public Observable<IdentifyState> identifyUserByCacheData(String clientId, String userIdentifier, String cacheData) {
        IdentificationApi api = Skynet.getService(Skynet.RETROFIT_FOR_IDENTIFY, IdentificationApi.class);
        IdentifyManuallyRequestParams identifyRequestParams = new IdentifyManuallyRequestParams();
        identifyRequestParams.data = cacheData;
        return api.identifyUserManual(clientId, userIdentifier, identifyRequestParams);
    }

    public Observable<IdentifyState> identifyUserFromTapTap(String clientId, String userId, String code, int fromTapTap) {
        String illegalArgument = "";
        if (TextUtils.isEmpty((CharSequence)clientId)) {
            illegalArgument = "clientId";
        } else if (TextUtils.isEmpty((CharSequence)userId)) {
            illegalArgument = "userId";
        }
        if (!TextUtils.isEmpty((CharSequence)illegalArgument)) {
            return Observable.error(new Throwable(illegalArgument + " param is empty"));
        }
        IdentificationApi api = Skynet.getService(Skynet.RETROFIT_FOR_IDENTIFY, IdentificationApi.class);
        return api.identifyUserFromTapTap(clientId, userId, code, fromTapTap);
    }
}

