/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.bridge.result;

import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class Result
implements Serializable {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_ERROR = -1;
    public int code;
    public String message;
    public String callbackId;
    public String content;
    public boolean onceTime;

    public static Result newInstance(boolean success, String resultContent, String message, String callbackId) {
        Result result = new Result();
        result.callbackId = callbackId;
        result.content = resultContent;
        result.code = success ? 0 : -1;
        result.message = message;
        return result;
    }

    public static Result newInstance(boolean success, String resultContent, String message, String callbackId, boolean onceTime) {
        Result result = new Result();
        result.callbackId = callbackId;
        result.content = resultContent;
        result.code = success ? 0 : -1;
        result.message = message;
        result.onceTime = onceTime;
        return result;
    }

    public String toJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("code", this.code);
            jsonObject.put("message", (Object)this.message);
            jsonObject.put("content", (Object)this.content);
            jsonObject.put("callbackId", (Object)this.callbackId);
            jsonObject.put("onceTime", this.onceTime);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + '\'' + ", callbackId='" + this.callbackId + '\'' + ", content='" + this.content + '\'' + ", onceTime=" + this.onceTime + '}';
    }
}

