/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.log;

public class TdsBaseException
extends Exception {
    public static final int UNAUTHORIZED = 401;
    public static final int SERVER_ERROR = 500;
    public static final String VERSION = " Version: 3.16.5";
    public final int errorCode;

    public TdsBaseException(String message) {
        super(message + VERSION);
        this.errorCode = 1000;
    }

    public TdsBaseException(String message, int errorCode) {
        super(message + VERSION + " errorCode: " + errorCode);
        this.errorCode = errorCode;
    }

    public TdsBaseException(String message, Throwable cause) {
        super(message + VERSION, cause);
        this.errorCode = 1000;
    }

    public TdsBaseException(Throwable cause) {
        super(VERSION, cause);
        this.errorCode = 1000;
    }

    public TdsBaseException(Throwable cause, int errorCode) {
        super(" Version: 3.16.5 errorCode: " + errorCode, cause);
        this.errorCode = errorCode;
    }

    @Override
    public String toString() {
        Throwable cause = this.getCause();
        if (cause == null) {
            return super.toString();
        }
        return super.toString() + "\n" + cause.toString();
    }
}

