/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.net.util;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import com.tds.common.account.LCAccount;
import com.tds.common.account.TDSPlatformAccount;
import com.tds.common.account.TapAccount;
import com.tds.common.account.TdsAccount;
import com.tds.common.net.exception.ServerException;
import com.tds.common.utils.CommonUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtil {
    private static Random random = new Random();
    public static String HTTP_METHOD_POST = "POST";
    public static String HTTP_METHOD_GET = "GET";

    public static <T> T parseJsonArray(JSONArray array, Class<?> type) throws JSONException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int len = array.length();
        Object result = Array.newInstance(type, len);
        for (int i = 0; i < len; ++i) {
            Object value = type.getDeclaredConstructor(JSONObject.class).newInstance(array.getJSONObject(i));
            Array.set(result, i, value);
        }
        return (T)result;
    }

    public static String getAuthorization(String url_string, String method, String keyid, String mac_key) {
        try {
            URL url = new URL(url_string);
            String time = HttpUtil.getTime();
            String randomStr = HttpUtil.getRandomString(5);
            String host = url.getHost();
            String uri = url_string.substring(url_string.lastIndexOf(host) + host.length());
            String port = "80";
            if (url_string.startsWith("https")) {
                port = "443";
            }
            String other = "";
            String sign = HttpUtil.sign(HttpUtil.mergeSign(time, randomStr, method, uri, host, port, other), mac_key);
            return "MAC " + HttpUtil.getAuthorizationParam("id", keyid) + "," + HttpUtil.getAuthorizationParam("ts", time) + "," + HttpUtil.getAuthorizationParam("nonce", randomStr) + "," + HttpUtil.getAuthorizationParam("mac", sign);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAuthorizationWithUrl(String url, String method, String keyid, String mac_key) {
        Uri uri = Uri.parse((String)url);
        String time = HttpUtil.getTime();
        String randomStr = HttpUtil.getRandomString(5);
        String host = uri.getHost();
        String port = "80";
        if (uri.getScheme().startsWith("wss")) {
            port = "443";
        }
        String other = "";
        String queries = uri.getEncodedQuery();
        String targetUrl = uri.getEncodedPath();
        if (queries != null && !queries.equals("null")) {
            targetUrl = targetUrl + "?" + queries;
        }
        String sign = HttpUtil.sign(HttpUtil.mergeSign(time, randomStr, method, targetUrl, host, port, other), mac_key);
        return "MAC " + HttpUtil.getAuthorizationParam("id", keyid) + "," + HttpUtil.getAuthorizationParam("ts", time) + "," + HttpUtil.getAuthorizationParam("nonce", randomStr) + "," + HttpUtil.getAuthorizationParam("mac", sign);
    }

    public static String getTime() {
        return String.format(Locale.US, "%010d", System.currentTimeMillis() / 1000L);
    }

    public static String getTimeMillis() {
        return String.format(Locale.US, "%010d", System.currentTimeMillis());
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String mergeSign(String time, String randomCode, String httpType, String uri, String domain, String port, String other) {
        if (TextUtils.isEmpty((CharSequence)time) || TextUtils.isEmpty((CharSequence)randomCode) || TextUtils.isEmpty((CharSequence)httpType) || TextUtils.isEmpty((CharSequence)domain) || TextUtils.isEmpty((CharSequence)port)) {
            return null;
        }
        String prefix = time + "\n" + randomCode + "\n" + httpType + "\n" + uri + "\n" + domain + "\n" + port + "\n";
        prefix = TextUtils.isEmpty((CharSequence)other) ? prefix + "\n" : prefix + other + "\n";
        return prefix;
    }

    public static String sign(String signatureBaseString, String key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] text = signatureBaseString.getBytes("UTF-8");
            byte[] signatureBytes = mac.doFinal(text);
            signatureBytes = Base64.encode((byte[])signatureBytes, (int)2);
            String signature = new String(signatureBytes, "UTF-8");
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getAuthorizationParam(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return key + "=\"" + value + "\"";
    }

    public static Map<String, String> getAuthorizeHeaders(TdsAccount account, String url, String method) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String authorization = null;
        String authType = null;
        switch (account.getAccountType()) {
            case XD: 
            case XDG: {
                authorization = "Bearer " + account.getToken().toString();
                break;
            }
            case TAP: {
                authorization = HttpUtil.getAuthorization(url, method, ((TapAccount)account).kid, ((TapAccount)account).mac_key);
                break;
            }
            case TDS: {
                authorization = HttpUtil.getAuthorization(url, method, ((TDSPlatformAccount)account).kid, ((TDSPlatformAccount)account).mac_key);
                break;
            }
            case LC: {
                if (!(account instanceof LCAccount)) break;
                LCAccount lcAccount = (LCAccount)account;
                headers.put("X-LC-Id", lcAccount.clientId);
                headers.put("X-LC-Sign", HttpUtil.getLcSign(lcAccount.clientToken));
                headers.put("X-LC-Session", lcAccount.sessionToken);
            }
        }
        authType = account.getAccountType().name();
        if (!TextUtils.isEmpty(authorization)) {
            headers.put("Authorization", authorization);
        }
        headers.put("X-Authorization-Type", authType);
        return headers;
    }

    public static String getLcSign(String clientToken) {
        String time = HttpUtil.getTimeMillis();
        String originalString = time + clientToken;
        return CommonUtils.getMD5(originalString.getBytes()) + "," + time;
    }

    public static String buildUrl(String url, Map<String, String> queries) {
        Uri uri = Uri.parse((String)url);
        Uri.Builder builder = uri.buildUpon();
        if (queries != null) {
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                builder.appendQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        return builder.build().toString();
    }

    public static String buildUrl(String schema, String host, String path) {
        Uri.Builder builder = new Uri.Builder().scheme(schema).authority(host).path(path);
        String result = "";
        try {
            result = builder.build().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String extractUrlHash(String url) {
        String result = "";
        try {
            URL originUrl = new URL(url);
            if (originUrl.getRef() != null) {
                result = originUrl.getRef();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    public static String extractUrlHost(String url) {
        String result = "";
        try {
            URL originUrl = new URL(url);
            if (originUrl.getHost() != null) {
                result = originUrl.getHost();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    public static String extractUrlFile(String url) {
        String result = "";
        try {
            URL originUrl = new URL(url);
            if (originUrl.getFile() != null) {
                result = originUrl.getFile();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    public static Pair<Integer, String> parseServerException(ServerException serverException) {
        int code = -1;
        String errorDescription = "";
        JSONObject responseBodyJSONObject = null;
        try {
            responseBodyJSONObject = new JSONObject(serverException.responseBody);
            if (responseBodyJSONObject.has("data")) {
                JSONObject dataJSONObject = responseBodyJSONObject.getJSONObject("data");
                if (dataJSONObject.has("code")) {
                    code = dataJSONObject.getInt("code");
                }
                if (dataJSONObject.has("error_description")) {
                    errorDescription = dataJSONObject.getString("error_description");
                }
                if (errorDescription.length() == 0 && dataJSONObject.has("msg")) {
                    errorDescription = dataJSONObject.getString("msg");
                }
            }
        }
        catch (Exception e) {
            responseBodyJSONObject = null;
            e.printStackTrace();
            String string = errorDescription = !TextUtils.isEmpty((CharSequence)serverException.getMessage()) ? serverException.getMessage() : e.getMessage();
        }
        if (responseBodyJSONObject == null && serverException.statusCode >= 400) {
            code = serverException.statusCode;
            errorDescription = serverException.responseBody;
            return new Pair((Object)code, (Object)errorDescription);
        }
        if (serverException.statusCode >= 400 && code == 0) {
            code = serverException.statusCode;
        }
        return new Pair((Object)code, (Object)errorDescription);
    }
}

