/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.oauth.views;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Outline;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.tds.common.R;
import com.tds.common.TapCommon;
import com.tds.common.localize.LocalizeManager;
import com.tds.common.net.util.HttpUtil;
import com.tds.common.oauth.AuthorizeResultCallBack;
import com.tds.common.oauth.models.AuthorizeFlow;
import com.tds.common.oauth.models.AuthorizeRequest;
import com.tds.common.oauth.models.AuthorizeResponse;
import com.tds.common.oauth.utils.CodeUtil;
import com.tds.common.oauth.utils.RegionUtil;
import com.tds.common.utils.ActivityUtils;
import com.tds.common.utils.CommonUtils;
import com.tds.common.utils.UIUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizeWebContainer {
    private Activity activity;
    private FrameLayout container;
    private FrameLayout webContainer;
    private ProgressBar progressBar;
    private WebView mWebView;
    private ImageView mClose;
    private View trickView;
    private int landscapeWidth = -1;
    private int portraitHeight = -1;
    private IWebLoginCallback callback;
    private String codeVerifier;
    AuthorizeRequest request;
    int cornerRadius;
    ValueAnimator loadingAnimator1;
    ValueAnimator loadingAnimator2;
    Bundle arguments;

    public void setLoginCallback(IWebLoginCallback callback) {
        this.callback = callback;
    }

    public void attachActivity(Activity activity, ViewGroup container) {
        this.onAttach(activity);
        View view = this.onCreateView(LayoutInflater.from((Context)activity), container);
        this.onCreate();
        container.addView(view);
        this.onViewCreated(view);
    }

    protected void onAttach(Activity activity) {
        this.activity = activity;
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container) {
        return inflater.inflate(R.layout.tds_common_webview_authorize, container, false);
    }

    protected void onCreate() {
    }

    protected void onViewCreated(View view) {
        final Activity activity = this.getActivity();
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        if (view == null) {
            return;
        }
        if (view.getContext() != null) {
            this.cornerRadius = UIUtils.dp2px(view.getContext(), 10.0f);
        }
        this.container = (FrameLayout)view.findViewById(R.id.container);
        this.webContainer = (FrameLayout)view.findViewById(R.id.web_container);
        this.trickView = view.findViewById(R.id.trickView);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress);
        this.mWebView = (WebView)view.findViewById(R.id.webview);
        this.mClose = (ImageView)view.findViewById(R.id.close);
        int width = (int)((float)AuthorizeWebContainer.getScreenMax((Context)activity) * 0.6f);
        int height = (int)((float)AuthorizeWebContainer.getScreenMax((Context)this.getActivity()) * 0.8f);
        if (width != -1) {
            this.landscapeWidth = width;
        }
        if (height != -1) {
            this.portraitHeight = height;
        }
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.finish();
            }
        });
        this.initWebView();
        this.resetLayout(this.getActivity().getResources().getConfiguration());
        this.request = (AuthorizeRequest)this.getArguments().getParcelable("request");
        this.codeVerifier = CodeUtil.getCodeVerifier(128);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", TapCommon.getTapConfig().clientId);
        params.put("response_type", "code");
        params.put("version", "3.16.5");
        params.put("platform", "android");
        StringBuilder permissions = new StringBuilder();
        if (this.request.getPermissions() != null) {
            for (int i = 0; i < this.request.getPermissions().length; ++i) {
                if (i == this.request.getPermissions().length - 1) {
                    permissions.append(this.request.getPermissions()[i]);
                    continue;
                }
                permissions.append(this.request.getPermissions()[i]).append(",");
            }
        }
        params.put("scope", permissions.toString());
        params.put("redirect_uri", "tapoauth://authorize");
        params.put("state", this.request.getState());
        params.put("code_challenge", CodeUtil.getCodeChallenge(this.codeVerifier));
        params.put("code_challenge_method", "S256");
        JSONObject info = new JSONObject();
        try {
            info.put("device_id", (Object)(Build.MANUFACTURER + " " + Build.MODEL));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("info", info.toString());
        String url = HttpUtil.buildUrl(RegionUtil.getRegionType(TapCommon.getTapConfig().regionType).authorizeUrl(), params);
        this.syncCookie();
        this.mWebView.getSettings().setUserAgentString("TapTapAndroidSDK/3.16.5 " + this.mWebView.getSettings().getUserAgentString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-SDK-UA", this.request.getInfo());
        this.mWebView.loadUrl(url, headers);
        this.startLoadingAnimation();
    }

    private void syncCookie() {
        CookieSyncManager.createInstance((Context)this.getActivity());
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        cookieManager.setCookie("https://www.xdrnd.com/", "skip_captcha=1");
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.flush();
        } else {
            CookieSyncManager.getInstance().sync();
        }
    }

    public static String convertHashMapToParameters(HashMap<String, String> params) {
        if (null != params && params.size() > 0) {
            StringBuilder encodedParams = new StringBuilder();
            try {
                Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
                int count = 0;
                while (iterator.hasNext()) {
                    Map.Entry<String, String> uee = iterator.next();
                    encodedParams.append(URLEncoder.encode(uee.getKey(), "UTF-8"));
                    encodedParams.append('=');
                    encodedParams.append(URLEncoder.encode(uee.getValue(), "UTF-8"));
                    if (count != params.size() - 1) {
                        encodedParams.append('&');
                    }
                    ++count;
                }
                return encodedParams.toString();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void startLoadingAnimation() {
        this.progressBar.setMax(1000);
        this.loadingAnimator1 = ValueAnimator.ofInt((int[])new int[]{0, 200}).setDuration(800L);
        this.loadingAnimator1.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int progress = (Integer)animation.getAnimatedValue();
                AuthorizeWebContainer.this.progressBar.setProgress(progress);
                if (progress == 200) {
                    AuthorizeWebContainer.this.startSecondLoadingAnimation();
                }
            }
        });
        this.loadingAnimator1.start();
    }

    private void startSecondLoadingAnimation() {
        this.loadingAnimator2 = ValueAnimator.ofInt((int[])new int[]{this.progressBar.getProgress(), 800}).setDuration(10000L);
        this.loadingAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int progress = (Integer)animation.getAnimatedValue();
                AuthorizeWebContainer.this.progressBar.setProgress(progress);
            }
        });
        this.loadingAnimator2.start();
    }

    protected void onDestroy() {
    }

    public void setArguments(Bundle arguments) {
        this.arguments = arguments;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public final Bundle getArguments() {
        return this.arguments;
    }

    private void initWebView() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), (float)AuthorizeWebContainer.this.cornerRadius);
                }
            });
            this.mWebView.setClipToOutline(true);
            this.trickView.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), (float)AuthorizeWebContainer.this.cornerRadius);
                }
            });
            this.trickView.setClipToOutline(true);
        }
        this.mWebView.setDownloadListener(new DownloadListener(){

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)url));
                try {
                    AuthorizeWebContainer.this.getActivity().startActivity(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.toLowerCase().startsWith("tapoauth")) {
                    Uri uri = Uri.parse((String)url);
                    String errorMsg = uri.getQueryParameter("error");
                    String code = uri.getQueryParameter("code");
                    String state = uri.getQueryParameter("state");
                    if (TextUtils.isEmpty((CharSequence)errorMsg)) {
                        AuthorizeFlow.exchangeTokenByCode(TapCommon.getTapConfig(), code, AuthorizeWebContainer.this.codeVerifier, state, new AuthorizeResultCallBack(){

                            @Override
                            public void onAuthorizeResult(AuthorizeResponse response) {
                                if (null != AuthorizeWebContainer.this.callback) {
                                    AuthorizeWebContainer.this.callback.onResponse(response);
                                }
                            }
                        });
                    } else {
                        AuthorizeResponse response = new AuthorizeResponse(null, state, errorMsg, null, false);
                        if (null != AuthorizeWebContainer.this.callback) {
                            AuthorizeWebContainer.this.callback.onResponse(response);
                        }
                    }
                    return true;
                }
                return false;
            }

            public void onLoadResource(WebView view, String url) {
                super.onLoadResource(view, url);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                AuthorizeWebContainer.this.endLoadingAnimation();
                AuthorizeWebContainer.this.injectJsInterface();
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient());
        WebSettings settings = this.mWebView.getSettings();
        settings.setAllowUniversalAccessFromFileURLs(false);
        settings.setAllowFileAccessFromFileURLs(false);
        settings.setAllowFileAccess(false);
        settings.setJavaScriptEnabled(true);
        settings.setSavePassword(false);
        settings.setSaveFormData(false);
        settings.setAppCacheEnabled(false);
        this.mWebView.removeJavascriptInterface("searchBoxJavaBridge_");
        this.mWebView.removeJavascriptInterface("accessibility");
        this.mWebView.removeJavascriptInterface("accessibilityTraversal");
        this.mWebView.addJavascriptInterface((Object)new UrlResource(), "urlResource");
        this.mWebView.setOverScrollMode(2);
        this.mWebView.setVerticalScrollBarEnabled(false);
    }

    private void injectJsInterface() {
        this.mWebView.loadUrl("javascript:window.TapTapAPI = function(action, params) {return window.urlResource.TapTapAPI(action, params);}");
        this.mWebView.loadUrl("javascript:window.TapTapAPI.openBrowser = function(param){return window.TapTapAPI('openBrowser', param)}");
        this.mWebView.loadUrl("javascript:window.TapTapAPI.tapEnv = function(param){return window.TapTapAPI('tapEnv', param)}");
    }

    private void endLoadingAnimation() {
        if (this.loadingAnimator1 != null && this.loadingAnimator1.isRunning()) {
            this.loadingAnimator1.cancel();
        }
        if (this.loadingAnimator2 != null && this.loadingAnimator2.isRunning()) {
            this.loadingAnimator2.cancel();
        }
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.progressBar.getProgress(), 1000}).setDuration(500L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int progress = (Integer)animation.getAnimatedValue();
                AuthorizeWebContainer.this.progressBar.setProgress(progress);
                if (progress == 1000) {
                    AuthorizeWebContainer.this.progressBar.setVisibility(8);
                }
            }
        });
        animator.start();
    }

    private static String getTapEnv() {
        JSONObject object = new JSONObject();
        try {
            object.put("MANUFACTURER", (Object)String.valueOf(Build.MANUFACTURER));
            object.put("MODEL", (Object)String.valueOf(Build.MODEL));
            object.put("VERSION_RELEASE", (Object)String.valueOf(Build.VERSION.RELEASE));
            object.put("VERSION_SDK_INT", (Object)String.valueOf(Build.VERSION.SDK_INT));
            object.put("VN_CODE", (Object)String.valueOf(31605001));
            object.put("VN_NAME", (Object)"3.16.5");
            object.put("LOC", (Object)CommonUtils.getCurrentLocale().getDisplayName());
            object.put("LANG", (Object)LocalizeManager.getPreferredLanguageString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.resetLayout(newConfig);
    }

    private void resetLayout(Configuration newConfig) {
        if (newConfig.orientation == 2) {
            int currentNightMode;
            if (this.landscapeWidth != -1) {
                ViewGroup.LayoutParams lp = this.container.getLayoutParams();
                lp.width = this.landscapeWidth + UIUtils.dp2px((Context)this.getActivity(), 48.0f);
                lp.height = -1;
                this.container.setLayoutParams(lp);
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.webContainer.getLayoutParams();
                int margin = UIUtils.dp2px((Context)this.getActivity(), 16.0f);
                int leftMargin = UIUtils.dp2px((Context)this.getActivity(), 48.0f);
                mlp.topMargin = margin;
                mlp.leftMargin = leftMargin;
                mlp.rightMargin = 0;
                mlp.bottomMargin = margin;
                this.webContainer.setLayoutParams((ViewGroup.LayoutParams)mlp);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mClose.getLayoutParams();
                layoutParams.gravity = 48;
                this.mClose.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                int padding = UIUtils.dp2px((Context)this.getActivity(), 7.0f);
                this.mClose.setPadding(padding, padding, padding, 0);
                ViewGroup.MarginLayoutParams closeMarginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
                closeMarginLayoutParams.setMargins(0, margin, 0, 0);
                this.mClose.setLayoutParams((ViewGroup.LayoutParams)closeMarginLayoutParams);
            }
            if ((currentNightMode = newConfig.uiMode & 0x30) == 32) {
                this.trickView.setBackgroundColor(0);
            } else {
                this.trickView.setBackgroundColor(-1);
            }
        } else if (newConfig.orientation == 1) {
            if (this.portraitHeight != -1) {
                ViewGroup.LayoutParams lp = this.container.getLayoutParams();
                lp.height = this.portraitHeight + UIUtils.dp2px((Context)this.getActivity(), 64.0f);
                lp.width = -1;
                this.container.setLayoutParams(lp);
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.webContainer.getLayoutParams();
                int margin = UIUtils.dp2px((Context)this.getActivity(), 20.0f);
                int bottomMargin = UIUtils.dp2px((Context)this.getActivity(), 64.0f);
                mlp.topMargin = margin;
                mlp.leftMargin = margin;
                mlp.rightMargin = margin;
                mlp.bottomMargin = bottomMargin;
                this.webContainer.setLayoutParams((ViewGroup.LayoutParams)mlp);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mClose.getLayoutParams();
                layoutParams.gravity = 81;
                this.mClose.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                int padding = UIUtils.dp2px((Context)this.getActivity(), 7.0f);
                this.mClose.setPadding(padding, padding, padding, 0);
                ViewGroup.MarginLayoutParams closeMarginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
                closeMarginLayoutParams.setMargins(0, UIUtils.dp2px((Context)this.getActivity(), 16.0f), 0, 0);
                this.mClose.setLayoutParams((ViewGroup.LayoutParams)closeMarginLayoutParams);
            }
            this.trickView.setBackgroundColor(0);
        }
    }

    public static int getScreenMax(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(outMetrics);
            return Math.max(outMetrics.heightPixels, outMetrics.widthPixels);
        }
        return -1;
    }

    public static interface IWebLoginCallback {
        public void onResponse(AuthorizeResponse var1);
    }

    final class UrlResource {
        UrlResource() {
        }

        @JavascriptInterface
        public String TapTapAPI(String action, final String params) {
            if (TextUtils.isEmpty((CharSequence)action) || null == AuthorizeWebContainer.this.mWebView) {
                return null;
            }
            if ("openBrowser".equals(action)) {
                AuthorizeWebContainer.this.mWebView.post(new Runnable(){

                    @Override
                    public void run() {
                        Uri uri = Uri.parse((String)params);
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        try {
                            AuthorizeWebContainer.this.getActivity().startActivity(intent);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            } else if ("tapEnv".equals(action)) {
                return AuthorizeWebContainer.getTapEnv();
            }
            return null;
        }
    }
}

