/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.permission;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.os.Build;
import com.tds.common.permission.PermissionConfig;
import com.tds.common.permission.PermissionFragment;
import com.tds.common.permission.RequestPermissionCallback;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PermissionCollection {
    private Activity activity;
    private Set<String> requestPermissions;
    private RequestPermissionCallback mCallback;
    private PermissionConfig config;

    public PermissionCollection(Activity activity) {
        this.activity = activity;
    }

    public PermissionCollection(Fragment fragment) {
        this.activity = fragment.getActivity();
    }

    public PermissionCollection permission(String ... permissions) {
        this.requestPermissions = new HashSet<String>(Arrays.asList(permissions));
        return this;
    }

    public PermissionCollection forwardSetting(PermissionConfig config) {
        this.config = config;
        return this;
    }

    public void request(RequestPermissionCallback callback) {
        this.mCallback = callback;
        if (this.activity != null) {
            this.request(this.activity);
        }
    }

    private void request(Activity activity) {
        FragmentManager fragmentManager = activity.getFragmentManager();
        PermissionFragment fragment = (PermissionFragment)fragmentManager.findFragmentByTag(PermissionFragment.TAG);
        if (fragment == null) {
            fragment = new PermissionFragment();
            if (!activity.isFinishing()) {
                fragment.start();
            }
            if (Build.VERSION.SDK_INT >= 24) {
                fragmentManager.beginTransaction().add((Fragment)fragment, PermissionFragment.TAG).commitNowAllowingStateLoss();
            } else {
                fragmentManager.beginTransaction().add((Fragment)fragment, PermissionFragment.TAG).commitAllowingStateLoss();
            }
        }
        fragment.requestPermission(this.requestPermissions, this.mCallback, this.config);
    }
}

