/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.internal.schedulers;

import com.tds.common.reactor.internal.schedulers.GenericScheduledExecutorServiceFactory;
import com.tds.common.reactor.internal.schedulers.NewThreadWorker;
import com.tds.common.reactor.schedulers.SchedulerLifecycle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;

public final class GenericScheduledExecutorService
implements SchedulerLifecycle {
    private static final ScheduledExecutorService[] NONE = new ScheduledExecutorService[0];
    private static final ScheduledExecutorService SHUTDOWN = Executors.newScheduledThreadPool(0);
    public static final GenericScheduledExecutorService INSTANCE;
    private final AtomicReference<ScheduledExecutorService[]> executor = new AtomicReference<ScheduledExecutorService[]>(NONE);
    private static int roundRobin;

    private GenericScheduledExecutorService() {
        this.start();
    }

    @Override
    public void start() {
        int count = Runtime.getRuntime().availableProcessors();
        if (count > 4) {
            count /= 2;
        }
        if (count > 8) {
            count = 8;
        }
        ScheduledExecutorService[] execs = new ScheduledExecutorService[count];
        for (int i = 0; i < count; ++i) {
            execs[i] = GenericScheduledExecutorServiceFactory.create();
        }
        if (this.executor.compareAndSet(NONE, execs)) {
            for (ScheduledExecutorService exec : execs) {
                if (NewThreadWorker.tryEnableCancelPolicy(exec) || !(exec instanceof ScheduledThreadPoolExecutor)) continue;
                NewThreadWorker.registerExecutor((ScheduledThreadPoolExecutor)exec);
            }
        } else {
            for (ScheduledExecutorService exec : execs) {
                exec.shutdownNow();
            }
        }
    }

    @Override
    public void shutdown() {
        ScheduledExecutorService[] execs;
        do {
            if ((execs = this.executor.get()) != NONE) continue;
            return;
        } while (!this.executor.compareAndSet(execs, NONE));
        for (ScheduledExecutorService exec : execs) {
            NewThreadWorker.deregisterExecutor(exec);
            exec.shutdownNow();
        }
    }

    public static ScheduledExecutorService getInstance() {
        ScheduledExecutorService[] execs = GenericScheduledExecutorService.INSTANCE.executor.get();
        if (execs == NONE) {
            return SHUTDOWN;
        }
        int r = roundRobin + 1;
        if (r >= execs.length) {
            r = 0;
        }
        roundRobin = r;
        return execs[r];
    }

    static {
        SHUTDOWN.shutdown();
        INSTANCE = new GenericScheduledExecutorService();
    }
}

