/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.behavior;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import com.tds.common.utils.UIUtils;
import com.tds.common.widgets.behavior.BottomSheetBehavior;
import java.lang.ref.WeakReference;
import tds.androidx.annotation.NonNull;
import tds.androidx.annotation.Nullable;
import tds.androidx.coordinatorlayout.widget.CoordinatorLayout;
import tds.androidx.core.math.MathUtils;
import tds.androidx.core.view.ViewCompat;
import tds.androidx.core.view.WindowInsetsCompat;
import tds.androidx.customview.widget.ViewDragHelper;
import tds.com.google.android.material.internal.ViewUtils;

public class RightSheetBehavior<V extends View>
extends BottomSheetBehavior<V> {
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){

        @Override
        public boolean tryCaptureView(@NonNull View child, int pointerId) {
            if (RightSheetBehavior.this.state == 1) {
                return false;
            }
            if (RightSheetBehavior.this.touchingScrollingChild) {
                return false;
            }
            if (RightSheetBehavior.this.state == 3 && RightSheetBehavior.this.activePointerId == pointerId) {
                View scroll;
                View view = scroll = RightSheetBehavior.this.nestedScrollingChildRef != null ? (View)RightSheetBehavior.this.nestedScrollingChildRef.get() : null;
                if (scroll != null && scroll.canScrollHorizontally(-1)) {
                    return false;
                }
            }
            return RightSheetBehavior.this.viewRef != null && RightSheetBehavior.this.viewRef.get() == child;
        }

        @Override
        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            RightSheetBehavior.this.dispatchOnSlide(left);
        }

        @Override
        public void onViewDragStateChanged(int state) {
            if (state == 1 && RightSheetBehavior.this.draggable) {
                RightSheetBehavior.this.setStateInternal(1);
            }
        }

        private boolean releasedLow(@NonNull View child) {
            return child.getLeft() > (RightSheetBehavior.this.parentHeight + RightSheetBehavior.this.getExpandedOffset()) / 2;
        }

        @Override
        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            int targetState;
            int top;
            if (xvel < 0.0f) {
                if (RightSheetBehavior.this.fitToContents) {
                    top = RightSheetBehavior.this.fitToContentsOffset;
                    targetState = 3;
                } else {
                    int currentTop = releasedChild.getLeft();
                    if (currentTop > RightSheetBehavior.this.halfExpandedOffset) {
                        top = RightSheetBehavior.this.halfExpandedOffset;
                        targetState = 6;
                    } else {
                        top = RightSheetBehavior.this.expandedOffset;
                        targetState = 3;
                    }
                }
            } else if (RightSheetBehavior.this.hideable && RightSheetBehavior.this.shouldHide(releasedChild, xvel)) {
                if (Math.abs(yvel) < Math.abs(xvel) && xvel > 500.0f || this.releasedLow(releasedChild)) {
                    top = RightSheetBehavior.this.parentHeight;
                    targetState = 5;
                } else if (RightSheetBehavior.this.fitToContents) {
                    top = RightSheetBehavior.this.fitToContentsOffset;
                    targetState = 3;
                } else if (Math.abs(releasedChild.getLeft() - RightSheetBehavior.this.expandedOffset) < Math.abs(releasedChild.getLeft() - RightSheetBehavior.this.halfExpandedOffset)) {
                    top = RightSheetBehavior.this.expandedOffset;
                    targetState = 3;
                } else {
                    top = RightSheetBehavior.this.halfExpandedOffset;
                    targetState = 6;
                }
            } else if (xvel == 0.0f || Math.abs(yvel) > Math.abs(xvel)) {
                int currentTop = releasedChild.getLeft();
                if (RightSheetBehavior.this.fitToContents) {
                    if (Math.abs(currentTop - RightSheetBehavior.this.fitToContentsOffset) < Math.abs(currentTop - RightSheetBehavior.this.collapsedOffset)) {
                        top = RightSheetBehavior.this.fitToContentsOffset;
                        targetState = 3;
                    } else {
                        top = RightSheetBehavior.this.collapsedOffset;
                        targetState = 4;
                    }
                } else if (currentTop < RightSheetBehavior.this.halfExpandedOffset) {
                    if (currentTop < Math.abs(currentTop - RightSheetBehavior.this.collapsedOffset)) {
                        top = RightSheetBehavior.this.expandedOffset;
                        targetState = 3;
                    } else {
                        top = RightSheetBehavior.this.halfExpandedOffset;
                        targetState = 6;
                    }
                } else if (Math.abs(currentTop - RightSheetBehavior.this.halfExpandedOffset) < Math.abs(currentTop - RightSheetBehavior.this.collapsedOffset)) {
                    top = RightSheetBehavior.this.halfExpandedOffset;
                    targetState = 6;
                } else {
                    top = RightSheetBehavior.this.collapsedOffset;
                    targetState = 4;
                }
            } else if (RightSheetBehavior.this.fitToContents) {
                top = RightSheetBehavior.this.collapsedOffset;
                targetState = 4;
            } else {
                int currentTop = releasedChild.getLeft();
                if (Math.abs(currentTop - RightSheetBehavior.this.halfExpandedOffset) < Math.abs(currentTop - RightSheetBehavior.this.collapsedOffset)) {
                    top = RightSheetBehavior.this.halfExpandedOffset;
                    targetState = 6;
                } else {
                    top = RightSheetBehavior.this.collapsedOffset;
                    targetState = 4;
                }
            }
            RightSheetBehavior.this.startSettlingAnimation(releasedChild, targetState, top, true);
        }

        @Override
        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            return child.getTop();
        }

        @Override
        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            return MathUtils.clamp(left, RightSheetBehavior.this.getExpandedOffset(), RightSheetBehavior.this.hideable ? RightSheetBehavior.this.parentHeight : RightSheetBehavior.this.collapsedOffset);
        }

        @Override
        public int getViewVerticalDragRange(@NonNull View child) {
            if (RightSheetBehavior.this.hideable) {
                return RightSheetBehavior.this.parentHeight;
            }
            return RightSheetBehavior.this.collapsedOffset;
        }
    };

    public RightSheetBehavior(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        if (ViewCompat.getFitsSystemWindows((View)parent) && !ViewCompat.getFitsSystemWindows(child)) {
            child.setFitsSystemWindows(true);
        }
        if (this.viewRef == null) {
            this.peekHeightMin = UIUtils.dp2px(parent.getContext(), 64.0f);
            this.setSystemGestureInsets((View)child);
            this.viewRef = new WeakReference<V>(child);
        }
        if (this.viewDragHelper == null) {
            this.viewDragHelper = ViewDragHelper.create(parent, this.dragCallback);
        }
        int savedTop = child.getLeft();
        parent.onLayoutChild((View)child, layoutDirection);
        this.parentWidth = parent.getHeight();
        this.parentHeight = parent.getWidth();
        this.childHeight = child.getWidth();
        this.fitToContentsOffset = Math.max(0, this.parentHeight - this.childHeight);
        this.calculateHalfExpandedOffset();
        this.calculateCollapsedOffset();
        if (this.state == 3) {
            ViewCompat.offsetLeftAndRight(child, this.getExpandedOffset());
        } else if (this.state == 6) {
            ViewCompat.offsetLeftAndRight(child, this.halfExpandedOffset);
        } else if (this.hideable && this.state == 5) {
            ViewCompat.offsetLeftAndRight(child, this.parentHeight);
        } else if (this.state == 4) {
            ViewCompat.offsetLeftAndRight(child, this.collapsedOffset);
        } else if (this.state == 1 || this.state == 2) {
            ViewCompat.offsetLeftAndRight(child, savedTop - child.getLeft());
        }
        this.nestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)child));
        return true;
    }

    @Override
    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown() || !this.draggable) {
            this.ignoreEvents = true;
            return false;
        }
        int action = event.getActionMasked();
        if (action == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        switch (action) {
            case 1: 
            case 3: {
                this.touchingScrollingChild = false;
                this.activePointerId = -1;
                if (!this.ignoreEvents) break;
                this.ignoreEvents = false;
                return false;
            }
            case 0: {
                int initialX = (int)event.getY();
                this.initialY = (int)event.getX();
                if (this.state != 2) {
                    View scroll;
                    View view = scroll = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
                    if (scroll != null && parent.isPointInChildBounds(scroll, this.initialY, initialX)) {
                        this.activePointerId = event.getPointerId(event.getActionIndex());
                        this.touchingScrollingChild = true;
                    }
                }
                this.ignoreEvents = this.activePointerId == -1 && !parent.isPointInChildBounds((View)child, this.initialY, initialX);
                break;
            }
        }
        if (!this.ignoreEvents && this.viewDragHelper != null && this.viewDragHelper.shouldInterceptTouchEvent(event)) {
            return true;
        }
        View scroll = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
        return action == 2 && scroll != null && !this.ignoreEvents && this.state != 1 && !parent.isPointInChildBounds(scroll, (int)event.getX(), (int)event.getY()) && this.viewDragHelper != null && Math.abs((float)this.initialY - event.getX()) > (float)this.viewDragHelper.getTouchSlop();
    }

    @Override
    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.state == 1 && action == 0) {
            return true;
        }
        if (this.viewDragHelper != null) {
            this.viewDragHelper.processTouchEvent(event);
        }
        if (action == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        if (this.viewDragHelper != null && action == 2 && !this.ignoreEvents && Math.abs((float)this.initialY - event.getX()) > (float)this.viewDragHelper.getTouchSlop()) {
            this.viewDragHelper.captureChildView((View)child, event.getPointerId(event.getActionIndex()));
        }
        return !this.ignoreEvents;
    }

    @Override
    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        this.lastNestedScrollDy = 0;
        this.nestedScrolled = false;
        return (axes & 1) != 0;
    }

    @Override
    public void onNestedPreScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        View scrollingChild;
        if (type == 1) {
            return;
        }
        View view = scrollingChild = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
        if (target != scrollingChild) {
            return;
        }
        int currentTop = child.getLeft();
        int newTop = currentTop - dx;
        if (dx > 0) {
            if (newTop < this.getExpandedOffset()) {
                consumed[0] = currentTop - this.getExpandedOffset();
                ViewCompat.offsetLeftAndRight(child, -consumed[0]);
                this.setStateInternal(3);
            } else {
                if (!this.draggable) {
                    return;
                }
                consumed[0] = dx;
                ViewCompat.offsetLeftAndRight(child, -dx);
                this.setStateInternal(1);
            }
        } else if (dx < 0 && !target.canScrollHorizontally(-1)) {
            if (newTop <= this.collapsedOffset || this.hideable) {
                if (!this.draggable) {
                    return;
                }
                consumed[0] = dx;
                ViewCompat.offsetLeftAndRight(child, -dx);
                this.setStateInternal(1);
            } else {
                consumed[0] = currentTop - this.collapsedOffset;
                ViewCompat.offsetLeftAndRight(child, -consumed[0]);
                this.setStateInternal(4);
            }
        }
        this.dispatchOnSlide(child.getLeft());
        this.lastNestedScrollDy = dx;
        this.nestedScrolled = true;
    }

    @Override
    public void onStopNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int type) {
        int targetState;
        int top;
        if (child.getLeft() == this.getExpandedOffset()) {
            this.setStateInternal(3);
            return;
        }
        if (this.nestedScrollingChildRef == null || target != this.nestedScrollingChildRef.get() || !this.nestedScrolled) {
            return;
        }
        if (this.lastNestedScrollDy > 0) {
            if (this.fitToContents) {
                top = this.fitToContentsOffset;
                targetState = 3;
            } else {
                int currentTop = child.getLeft();
                if (currentTop > this.halfExpandedOffset) {
                    top = this.halfExpandedOffset;
                    targetState = 6;
                } else {
                    top = this.expandedOffset;
                    targetState = 3;
                }
            }
        } else if (this.hideable && this.shouldHide((View)child, this.getYVelocity())) {
            top = this.parentHeight;
            targetState = 5;
        } else if (this.lastNestedScrollDy == 0) {
            int currentTop = child.getLeft();
            if (this.fitToContents) {
                if (Math.abs(currentTop - this.fitToContentsOffset) < Math.abs(currentTop - this.collapsedOffset)) {
                    top = this.fitToContentsOffset;
                    targetState = 3;
                } else {
                    top = this.collapsedOffset;
                    targetState = 4;
                }
            } else if (currentTop < this.halfExpandedOffset) {
                if (currentTop < Math.abs(currentTop - this.collapsedOffset)) {
                    top = this.expandedOffset;
                    targetState = 3;
                } else {
                    top = this.halfExpandedOffset;
                    targetState = 6;
                }
            } else if (Math.abs(currentTop - this.halfExpandedOffset) < Math.abs(currentTop - this.collapsedOffset)) {
                top = this.halfExpandedOffset;
                targetState = 6;
            } else {
                top = this.collapsedOffset;
                targetState = 4;
            }
        } else if (this.fitToContents) {
            top = this.collapsedOffset;
            targetState = 4;
        } else {
            int currentTop = child.getLeft();
            if (Math.abs(currentTop - this.halfExpandedOffset) < Math.abs(currentTop - this.collapsedOffset)) {
                top = this.halfExpandedOffset;
                targetState = 6;
            } else {
                top = this.collapsedOffset;
                targetState = 4;
            }
        }
        this.startSettlingAnimation((View)child, targetState, top, false);
        this.nestedScrolled = false;
    }

    @Override
    boolean shouldHide(@NonNull View child, float yvel) {
        if (this.skipCollapsed) {
            return true;
        }
        if (child.getLeft() < this.collapsedOffset) {
            return false;
        }
        int peek = this.calculatePeekHeight();
        float newTop = (float)child.getLeft() + yvel * 0.1f;
        return Math.abs(newTop - (float)this.collapsedOffset) / (float)peek > 0.5f;
    }

    @Override
    protected void setSystemGestureInsets(@NonNull View child) {
        if (Build.VERSION.SDK_INT >= 29 && !this.isGestureInsetBottomIgnored() && !this.peekHeightAuto) {
            ViewUtils.doOnApplyWindowInsets(child, new ViewUtils.OnApplyWindowInsetsListener(){

                @Override
                public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat insets, ViewUtils.RelativePadding initialPadding) {
                    RightSheetBehavior.this.gestureInsetBottom = insets.getMandatorySystemGestureInsets().right;
                    RightSheetBehavior.this.updatePeekHeight(false);
                    return insets;
                }
            });
        }
    }

    @Override
    protected float getYVelocity() {
        if (this.velocityTracker == null) {
            return 0.0f;
        }
        this.velocityTracker.computeCurrentVelocity(1000, this.maximumVelocity);
        return this.velocityTracker.getXVelocity(this.activePointerId);
    }

    @Override
    void startSettlingAnimation(View child, int state, int top, boolean settleFromViewDragHelper) {
        boolean startedSettling;
        boolean bl = this.viewDragHelper != null && (settleFromViewDragHelper ? this.viewDragHelper.settleCapturedViewAt(top, child.getTop()) : this.viewDragHelper.smoothSlideViewTo(child, top, child.getTop())) ? true : (startedSettling = false);
        if (startedSettling) {
            this.setStateInternal(2);
            if (this.settleRunnable == null) {
                this.settleRunnable = new BottomSheetBehavior.SettleRunnable(this, child, state);
            }
            if (!this.settleRunnable.isPosted) {
                this.settleRunnable.targetState = state;
                ViewCompat.postOnAnimation(child, this.settleRunnable);
                this.settleRunnable.isPosted = true;
            } else {
                this.settleRunnable.targetState = state;
            }
        } else {
            this.setStateInternal(state);
        }
    }
}

