/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.slidesheet;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.tds.common.R;
import com.tds.common.widgets.behavior.BottomSheetBehavior;
import com.tds.common.widgets.behavior.RightSheetBehavior;
import tds.androidx.coordinatorlayout.widget.CoordinatorLayout;

public class SlideSheetDialog
extends Dialog {
    private BottomSheetBehavior<FrameLayout> behavior;
    private FrameLayout container;
    private FrameLayout bottomSheet;
    boolean dismissWithAnimation;
    boolean cancelable = true;
    private boolean canceledOnTouchOutside = true;
    private boolean canceledOnTouchOutsideSet;
    private final boolean isLandscape;
    private CoordinatorLayout coordinator;
    private BottomSheetBehavior.BottomSheetCallback bottomSheetCallback = new BottomSheetBehavior.BottomSheetCallback(){

        @Override
        public void onStateChanged(View bottomSheet, int newState) {
            if (newState == 5) {
                SlideSheetDialog.this.cancel();
            }
        }

        @Override
        public void onSlide(View bottomSheet, float slideOffset) {
        }
    };

    public SlideSheetDialog(Context context, boolean isLandscape) {
        super(context);
        this.getWindow().setFlags(0x1000000, 0x1000000);
        this.requestWindowFeature(1);
        this.isLandscape = isLandscape;
        if (context instanceof Activity) {
            this.setOwnerActivity((Activity)context);
        }
    }

    public SlideSheetDialog(Context context, boolean isLandscape, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context);
        this.requestWindowFeature(1);
        this.isLandscape = isLandscape;
        this.cancelable = cancelable;
        if (context instanceof Activity) {
            this.setOwnerActivity((Activity)context);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        if (window != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
            }
            window.setLayout(-1, -1);
            window.getAttributes().windowAnimations = this.isLandscape ? R.style.tds_common_animation_slideSheetDialog_landscape : R.style.tds_common_animation_slideSheetDialog_portrait;
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    public void setContentView(int layoutResID) {
        super.setContentView(this.wrapInBottomSheet(layoutResID, null, null));
    }

    public void setContentView(View view) {
        super.setContentView(this.wrapInBottomSheet(0, view, null));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(this.wrapInBottomSheet(0, view, params));
    }

    public void setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        if (this.cancelable != cancelable) {
            this.cancelable = cancelable;
            if (this.behavior != null) {
                this.behavior.setHideable(cancelable);
            }
        }
    }

    public void show() {
        super.show();
    }

    protected void onStart() {
        super.onStart();
        if (this.behavior != null && this.behavior.getState() == 5) {
            this.behavior.setState(4);
        }
    }

    public void cancel() {
        BottomSheetBehavior<FrameLayout> behavior = this.getBehavior();
        if (!this.dismissWithAnimation || behavior.getState() == 5) {
            super.cancel();
        } else {
            behavior.setState(5);
        }
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        if (cancel && !this.cancelable) {
            this.cancelable = true;
        }
        this.canceledOnTouchOutside = cancel;
        this.canceledOnTouchOutsideSet = true;
    }

    public BottomSheetBehavior<FrameLayout> getBehavior() {
        if (this.behavior == null) {
            this.ensureContainerAndBehavior();
        }
        return this.behavior;
    }

    public void setDismissWithAnimation(boolean dismissWithAnimation) {
        this.dismissWithAnimation = dismissWithAnimation;
    }

    public boolean getDismissWithAnimation() {
        return this.dismissWithAnimation;
    }

    private FrameLayout ensureContainerAndBehavior() {
        if (this.container == null) {
            this.container = new FrameLayout(this.getContext());
            this.container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.container.setBackgroundColor(0x66000000);
            this.coordinator = new CoordinatorLayout(this.getContext());
            this.coordinator.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            View touchOutsideView = new View(this.getContext());
            touchOutsideView.setFocusable(false);
            touchOutsideView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            touchOutsideView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SlideSheetDialog.this.cancelable && SlideSheetDialog.this.isShowing() && SlideSheetDialog.this.shouldWindowCloseOnTouchOutside()) {
                        SlideSheetDialog.this.cancel();
                    }
                }
            });
            this.coordinator.addView(touchOutsideView);
            this.bottomSheet = new FrameLayout(this.getContext());
            this.behavior = this.isLandscape ? new RightSheetBehavior<FrameLayout>(this.getContext(), null) : new BottomSheetBehavior(this.getContext(), null);
            this.behavior.setHideable(true);
            this.behavior.addBottomSheetCallback(this.bottomSheetCallback);
            this.behavior.setHideable(this.cancelable);
            CoordinatorLayout.LayoutParams bottomSheetLP = new CoordinatorLayout.LayoutParams(-1, -1);
            bottomSheetLP.setBehavior(this.behavior);
            this.bottomSheet.setLayoutParams((ViewGroup.LayoutParams)bottomSheetLP);
            this.coordinator.addView((View)this.bottomSheet);
            this.container.addView((View)this.coordinator);
        }
        return this.container;
    }

    private View wrapInBottomSheet(int layoutResId, View view, ViewGroup.LayoutParams params) {
        this.ensureContainerAndBehavior();
        if (layoutResId != 0 && view == null) {
            view = this.getLayoutInflater().inflate(layoutResId, (ViewGroup)this.coordinator, false);
        }
        this.bottomSheet.removeAllViews();
        if (params != null) {
            this.bottomSheet.addView(view, params);
        } else {
            this.bottomSheet.addView(view);
        }
        this.bottomSheet.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                return true;
            }
        });
        return this.container;
    }

    boolean shouldWindowCloseOnTouchOutside() {
        if (!this.canceledOnTouchOutsideSet) {
            TypedArray a = this.getContext().obtainStyledAttributes(new int[]{16843611});
            this.canceledOnTouchOutside = a.getBoolean(0, true);
            a.recycle();
            this.canceledOnTouchOutsideSet = true;
        }
        return this.canceledOnTouchOutside;
    }
}

