/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.yasirkula.unity.NativeGalleryMediaPickerFragment;
import com.yasirkula.unity.NativeGalleryMediaReceiver;
import com.yasirkula.unity.NativeGalleryUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class NativeGalleryMediaPickerResultOperation {
    private final Context context;
    private final NativeGalleryMediaReceiver mediaReceiver;
    private final Intent data;
    private final boolean selectMultiple;
    private final String savePathDirectory;
    private final String savePathFilename;
    private ArrayList<String> savedFiles;
    public boolean finished;
    public boolean sentResult;
    public int progress;
    private boolean cancelled;
    private String unityResult;

    public NativeGalleryMediaPickerResultOperation(Context context, NativeGalleryMediaReceiver mediaReceiver, Intent data, boolean selectMultiple, String savePathDirectory, String savePathFilename) {
        this.context = context;
        this.mediaReceiver = mediaReceiver;
        this.data = data;
        this.selectMultiple = selectMultiple;
        this.savePathDirectory = savePathDirectory;
        this.savePathFilename = savePathFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.unityResult = "";
        this.progress = -1;
        try {
            if (!this.selectMultiple || this.data.getClipData() == null) {
                this.unityResult = this.getPathFromURI(this.data.getData());
                if (this.unityResult == null || this.unityResult.length() > 0 && !new File(this.unityResult).exists()) {
                    this.unityResult = "";
                }
            } else {
                boolean isFirstResult = true;
                int count = this.data.getClipData().getItemCount();
                for (int i = 0; i < count; ++i) {
                    if (this.cancelled) {
                        return;
                    }
                    String _unityResult = this.getPathFromURI(this.data.getClipData().getItemAt(i).getUri());
                    if (_unityResult == null || _unityResult.length() <= 0 || !new File(_unityResult).exists()) continue;
                    if (isFirstResult) {
                        this.unityResult = this.unityResult + _unityResult;
                        isFirstResult = false;
                        continue;
                    }
                    this.unityResult = this.unityResult + ">" + _unityResult;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
        }
        finally {
            this.progress = 100;
            this.finished = true;
        }
    }

    public void cancel() {
        if (this.cancelled || this.finished) {
            return;
        }
        Log.d((String)"Unity", (String)"Cancelled NativeGalleryMediaPickerResultOperation!");
        this.cancelled = true;
        this.unityResult = "";
    }

    public void sendResultToUnity() {
        if (this.sentResult) {
            return;
        }
        this.sentResult = true;
        if (this.mediaReceiver == null) {
            Log.d((String)"Unity", (String)"NativeGalleryMediaPickerResultOperation.mediaReceiver became null!");
        } else if (this.selectMultiple) {
            this.mediaReceiver.OnMultipleMediaReceived(this.unityResult);
        } else {
            this.mediaReceiver.OnMediaReceived(this.unityResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPathFromURI(Uri uri) {
        if (uri == null) {
            return null;
        }
        Log.d((String)"Unity", (String)("Selected media uri: " + uri.toString()));
        String path = NativeGalleryUtils.GetPathFromURI(this.context, uri);
        if (path != null && path.length() > 0) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(path));
                inputStream.read();
                String string2 = path;
                return string2;
            }
            catch (Exception exception) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.copyToTempFile(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyToTempFile(Uri uri) {
        String string2;
        InputStream input;
        block35: {
            ContentResolver resolver = this.context.getContentResolver();
            Cursor returnCursor = null;
            String filename = null;
            long fileSize = -1L;
            long copiedBytes = 0L;
            try {
                returnCursor = resolver.query(uri, null, null, null, null);
                if (returnCursor != null && returnCursor.moveToFirst()) {
                    filename = returnCursor.getString(returnCursor.getColumnIndex("_display_name"));
                    fileSize = returnCursor.getLong(returnCursor.getColumnIndex("_size"));
                }
            }
            catch (Exception e) {
                Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            }
            finally {
                if (returnCursor != null) {
                    returnCursor.close();
                }
            }
            if (filename == null || filename.length() < 3) {
                filename = "temp";
            }
            String extension = null;
            int filenameExtensionIndex = filename.lastIndexOf(46);
            if (filenameExtensionIndex > 0 && filenameExtensionIndex < filename.length() - 1) {
                extension = filename.substring(filenameExtensionIndex);
            } else {
                String mimeExtension;
                String mime = resolver.getType(uri);
                if (mime != null && (mimeExtension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mime)) != null && mimeExtension.length() > 0) {
                    extension = "." + mimeExtension;
                }
            }
            if (extension == null) {
                extension = ".tmp";
            }
            if (!NativeGalleryMediaPickerFragment.tryPreserveFilenames) {
                filename = this.savePathFilename;
            } else if (filename.endsWith(extension)) {
                filename = filename.substring(0, filename.length() - extension.length());
            }
            input = resolver.openInputStream(uri);
            if (input == null) {
                return null;
            }
            if (fileSize < 0L) {
                try {
                    fileSize = input.available();
                }
                catch (Exception mimeExtension) {
                    // empty catch block
                }
                if (fileSize < 0L) {
                    fileSize = 0L;
                }
            }
            String fullName = filename + extension;
            if (this.savedFiles != null) {
                int n = 1;
                for (int i = 0; i < this.savedFiles.size(); ++i) {
                    if (!this.savedFiles.get(i).equals(fullName)) continue;
                    fullName = filename + ++n + extension;
                    i = -1;
                }
            }
            File tempFile = new File(this.savePathDirectory, fullName);
            FileOutputStream output = null;
            try {
                int len;
                output = new FileOutputStream(tempFile, false);
                this.progress = fileSize > 0L ? 0 : -1;
                byte[] buf = new byte[4096];
                while ((len = input.read(buf)) > 0 && !this.cancelled) {
                    ((OutputStream)output).write(buf, 0, len);
                    if (fileSize <= 0L) continue;
                    this.progress = (int)((double)(copiedBytes += (long)len) / (double)fileSize * 100.0);
                    if (this.progress <= 100) continue;
                    this.progress = 100;
                }
                if (this.cancelled) {
                    ((OutputStream)output).close();
                    output = null;
                    tempFile.delete();
                } else if (fileSize > 0L) {
                    this.progress = 100;
                }
                if (this.selectMultiple) {
                    if (this.savedFiles == null) {
                        this.savedFiles = new ArrayList();
                    }
                    this.savedFiles.add(fullName);
                }
                string2 = tempFile.getAbsolutePath();
                if (output == null) break block35;
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        ((OutputStream)output).close();
                    }
                    input.close();
                    throw throwable;
                }
                catch (Exception e) {
                    Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
                    return null;
                }
            }
            ((OutputStream)output).close();
        }
        input.close();
        return string2;
    }
}

