/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.utils;

import android.text.format.DateFormat;
import com.tapsdk.antiaddiction.entities.ChildProtectedConfig;
import com.tapsdk.antiaddiction.settings.AntiAddictionSettings;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    public static final int SECONDS_IN_DAY = 86400;
    public static final long MILLIS_IN_DAY = 86400000L;

    public static boolean isHoliday(long time) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM.dd", Locale.getDefault());
        String dateString = formatter.format(time);
        int month = Integer.parseInt(TimeUtil.dropZero(dateString.substring(0, 2)));
        int day = Integer.parseInt(TimeUtil.dropZero(dateString.substring(3)));
        String current = (month > 9 ? Integer.valueOf(month) : "0" + month) + "." + (day > 9 ? Integer.valueOf(day) : "0" + day);
        return AntiAddictionSettings.getInstance().isHoliday(current);
    }

    private static String dropZero(String str) {
        if (str != null && str.length() > 1) {
            if (str.startsWith("0")) {
                return str.substring(1);
            }
            return str;
        }
        return str;
    }

    public static boolean isSameDayOfMillis(long ms1, long ms2) {
        long interval = ms1 - ms2;
        return interval < 86400000L && interval > -86400000L && TimeUtil.toDay(ms1) == TimeUtil.toDay(ms2);
    }

    private static long toDay(long millis) {
        return (millis + (long)TimeZone.getDefault().getOffset(millis)) / 86400000L;
    }

    public static int diffNow(String dateStr, long serverTime) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date date = null;
        try {
            date = fmt.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (date == null) {
            return Integer.MAX_VALUE;
        }
        Date curDate = new Date(serverTime);
        return (int)((date.getTime() - curDate.getTime()) / 1000L);
    }

    public static Date getTomorrowDate(Date today) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.set(5, calendar.get(5) + 1);
        return calendar.getTime();
    }

    public static int getTimeToNightStrict(String nightStrictStartTime, String nightStrictEndTime, long serverTime) {
        AntiAddictionLogger.d("getTimeToNightStrict start");
        Date now = new Date(serverTime);
        SimpleDateFormat formatToMinute = new SimpleDateFormat("HH:mm");
        SimpleDateFormat formatToDay = new SimpleDateFormat("yyyy-MM-dd");
        String nowStr = formatToMinute.format(now);
        if (nightStrictStartTime == null || nightStrictStartTime.isEmpty() || nightStrictEndTime == null || nightStrictEndTime.isEmpty() || nightStrictStartTime.compareTo(nightStrictEndTime) == 0) {
            return Integer.MAX_VALUE;
        }
        if (nightStrictStartTime.compareTo(nightStrictEndTime) < 0) {
            if (nowStr.compareTo(nightStrictEndTime) != 0 && nowStr.compareTo(nightStrictStartTime) * nowStr.compareTo(nightStrictEndTime) <= 0) {
                return 0;
            }
        } else if (nowStr.compareTo(nightStrictEndTime) != 0) {
            String middleNightBeforeStr = "23:59";
            String middleNightAfterStr = "00:00";
            if (nowStr.compareTo(nightStrictStartTime) * nowStr.compareTo(middleNightBeforeStr) <= 0 || nowStr.compareTo(middleNightAfterStr) * nowStr.compareTo(nightStrictEndTime) <= 0) {
                return 0;
            }
        }
        String dStr = "";
        if (nowStr.compareTo(nightStrictStartTime) < 0) {
            dStr = formatToDay.format(now);
        } else {
            Date tomorrow = TimeUtil.getTomorrowDate(new Date());
            dStr = formatToDay.format(tomorrow);
        }
        String strictStartStr = dStr + " " + nightStrictStartTime;
        AntiAddictionLogger.d("getTimeToNightStrict start:" + strictStartStr);
        return TimeUtil.diffNow(strictStartStr, serverTime);
    }

    public static String getFullTime(long timeInMillis) {
        try {
            CharSequence val = DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (Date)new Date(timeInMillis));
            return val.toString();
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    public static int getAntiAddictionTime(int ageLimit, ChildProtectedConfig config, long timeInMillis) {
        int gameTime = ageLimit < 0 ? config.noIdentifyTime : (AntiAddictionSettings.getInstance().isHolidayInMillis(new Date(timeInMillis).getTime()) ? config.childHolidayTime : config.childCommonTime);
        return gameTime;
    }

    public static int getMinute(int remainTime) {
        int min = remainTime / 60;
        if (remainTime % 60 != 0) {
            ++min;
        }
        return min;
    }

    public static String getRestTime(String description, int remainTime) {
        String result = description;
        if (remainTime < 60) {
            int index = description.indexOf("# ${remaining} #");
            if (index >= 0) {
                String substring1 = description.substring(0, index);
                String substring2 = description.substring(index);
                result = substring1 + substring2.replace("# ${remaining} #", String.valueOf(remainTime)).replace("\u5206\u949f", "\u79d2");
            }
        } else {
            result = description.replace("# ${remaining} #", String.valueOf(remainTime / 60));
        }
        return result;
    }
}

