/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.bridge;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tds.common.bridge.BridgeCallback;
import com.tds.common.bridge.BridgeHolder;
import com.tds.common.bridge.IBridge;
import com.tds.common.bridge.IBridgeService;
import com.tds.common.bridge.command.Command;
import com.tds.common.bridge.command.CommandTaskImpl;
import com.tds.common.bridge.exception.EngineBridgeException;
import com.tds.common.bridge.result.Result;
import com.tds.common.bridge.utils.BridgeLogger;
import com.tds.common.bridge.utils.BridgeReflect;
import com.tds.common.utils.EngineUtil;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;

public class Bridge
implements IBridge {
    private WeakReference<Activity> mWeakReference;
    private Handler mEngineHandler;
    private Map<String, BridgeCallback> mBridgeCallbackMaps;

    private Bridge() {
    }

    public static Bridge getInstance() {
        return Holder.sInstance;
    }

    @Override
    public void init(Activity activity) {
        BridgeLogger.i("[EngineBridge] init!");
        this.mWeakReference = new WeakReference<Activity>(activity);
        this.mBridgeCallbackMaps = new ConcurrentHashMap<String, BridgeCallback>();
    }

    @Override
    public void register(Class<? extends IBridgeService> clz, IBridgeService service) {
        if (clz.isInterface() && BridgeReflect.checkServiceLegal(clz)) {
            BridgeHolder.INSTANCE.register(clz, service);
            return;
        }
        Class<? extends IBridgeService> registerClz = BridgeReflect.getLegalService(clz);
        if (registerClz != null) {
            BridgeHolder.INSTANCE.register(registerClz, service);
            return;
        }
        throw new EngineBridgeException("\u6ce8\u518c\u7684IBridgeService\u51fa\u73b0\u9519\u8bef");
    }

    @Override
    public void registerHandler(String json, final BridgeCallback callback) {
        BridgeLogger.i("Command from Engine Bridge:" + json);
        if (this.getActivity() == null) {
            BridgeLogger.i("Bridge must be init!");
            return;
        }
        final Command command = new Command(json);
        if (command.callback && this.mBridgeCallbackMaps != null && !this.mBridgeCallbackMaps.containsKey(command.callbackId)) {
            this.mBridgeCallbackMaps.put(command.callbackId, callback);
        }
        this.createEngineHandler();
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Bridge.this.execute(command, callback);
                }
            });
            return;
        }
        this.execute(command, callback);
    }

    @Override
    public void callHandler(String json) {
        this.registerHandler(json, new BridgeCallback(){

            @Override
            public void onResult(String json) {
                try {
                    if (EngineUtil.isUnreal()) {
                        BridgeLogger.i("BridgeCallback send Message to Unreal Engine");
                        Bridge.nativeOnResult(json);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void execute(final Command command, final BridgeCallback callback) {
        BridgeLogger.i("Bridge start to execute command");
        try {
            new CommandTaskImpl().execute(command, new BridgeCallback(){

                @Override
                public void onResult(String resultJson) {
                    Bridge.this.sendMessage(Result.newInstance(true, resultJson, "Success", command.callbackId, command.onceTime), callback);
                }
            });
        }
        catch (EngineBridgeException e) {
            BridgeLogger.i("BridgeException:" + e.getClass().getName());
            this.sendMessage(Result.newInstance(false, null, e.getMessage(), command.callbackId, command.onceTime), callback);
        }
    }

    private void sendMessage(Result result, BridgeCallback callback) {
        if (this.mEngineHandler == null) {
            BridgeLogger.i("EngineHandler isn't init, BridgeCallback send Message to Engine");
            callback.onResult(result.toJSON());
            return;
        }
        Message message = Message.obtain();
        message.obj = result;
        BridgeLogger.i("EngineHandler send Message to Engine");
        if (!this.mEngineHandler.sendMessage(message)) {
            throw new RejectedExecutionException("Current Thread is Shutting Down");
        }
    }

    private void createEngineHandler() {
        if (EngineUtil.isUnreal()) {
            return;
        }
        if (Thread.currentThread() == Looper.getMainLooper().getThread() || this.mEngineHandler != null) {
            BridgeLogger.i("Bridge Engine Handler already init or Current Thread is main Thread");
            return;
        }
        if (Looper.myLooper() != null) {
            BridgeLogger.i("Looper is already prepare,start to create EngineHandler");
            this.constructorEngineHandler(Looper.myLooper());
            return;
        }
        BridgeLogger.i("Looper prepare,start to create EngineHandler");
        Looper.prepare();
        this.constructorEngineHandler(Looper.myLooper());
        BridgeLogger.i("Looper start loop:" + Objects.requireNonNull(Looper.myLooper()).getThread());
        Looper.loop();
    }

    private void constructorEngineHandler(Looper looper) {
        BridgeLogger.i("\u521d\u59cb\u5316 Bridge Thread Handler:" + Thread.currentThread().getName());
        this.mEngineHandler = new Handler(looper, new Handler.Callback(){

            public boolean handleMessage(Message message) {
                BridgeLogger.i("Bridge Engine Handler Thread:" + Thread.currentThread().getName() + "\n Message:" + message.obj);
                if (message.obj != null) {
                    Result result = (Result)message.obj;
                    BridgeCallback callback = (BridgeCallback)Bridge.this.mBridgeCallbackMaps.get(result.callbackId);
                    if (callback != null) {
                        callback.onResult(result.toJSON());
                        if (result.onceTime) {
                            BridgeLogger.i("Bridge Engine CallbackHolder remove currentCallback:" + result.callbackId);
                            Bridge.this.mBridgeCallbackMaps.remove(result.callbackId);
                        }
                        BridgeLogger.i("Bridge Engine Callback Holder Last:" + Bridge.this.mBridgeCallbackMaps.size());
                    }
                }
                return false;
            }
        });
        BridgeLogger.i("\u542f\u52a8 Looper:" + Thread.currentThread().getId());
    }

    public Activity getActivity() {
        return (Activity)this.mWeakReference.get();
    }

    public static synchronized native void nativeOnResult(String var0) throws EngineBridgeException;

    private static class Holder {
        private static Bridge sInstance = new Bridge();

        private Holder() {
        }
    }
}

