/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.bridge.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class BridgeJsonHelper {
    private static final String TAG = BridgeJsonHelper.class.getSimpleName();

    public static <T> T parseJson2Object(Class<T> clazz, String json) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BridgeJsonHelper.parseJson2Object(clazz, jsonObject);
    }

    private static <T> T parseJson2Object(Class<T> clazz, JSONObject jsonObject) {
        T obj = null;
        try {
            Field[] fields;
            obj = clazz.newInstance();
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Class<?> typeClazz = field.getType();
                if (typeClazz.isPrimitive()) {
                    BridgeJsonHelper.setProperty(obj, field, jsonObject.opt(field.getName()));
                    continue;
                }
                Object typeObj = typeClazz.isInterface() && typeClazz.getSimpleName().contains("List") ? ArrayList.class.newInstance() : typeClazz.newInstance();
                if (typeObj instanceof List) {
                    Type type = field.getGenericType();
                    ParameterizedType pt = (ParameterizedType)type;
                    Class dataClass = (Class)pt.getActualTypeArguments()[0];
                    JSONArray jArray = jsonObject.getJSONArray(field.getName());
                    for (int i = 0; i < jArray.length(); ++i) {
                        ((List)typeObj).add(BridgeJsonHelper.parseJson2Object(dataClass, jsonObject.getJSONArray(field.getName()).getJSONObject(i)));
                    }
                    BridgeJsonHelper.setProperty(obj, field, typeObj);
                    continue;
                }
                if (typeObj instanceof String) {
                    BridgeJsonHelper.setProperty(obj, field, jsonObject.opt(field.getName()));
                    continue;
                }
                BridgeJsonHelper.setProperty(obj, field, BridgeJsonHelper.parseJson2Object(typeClazz, jsonObject.getJSONObject(field.getName())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    private static void setProperty(Object obj, Field field, Object valueObj) {
        try {
            Class<?> clazz = obj.getClass();
            Method method = clazz.getDeclaredMethod("set" + field.getName().substring(0, 1).toUpperCase(Locale.getDefault()) + field.getName().substring(1), field.getType());
            method.setAccessible(true);
            method.invoke(obj, valueObj);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static String object2JsonString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof String) {
            return "\"" + BridgeJsonHelper.escape((String)value) + "\"";
        }
        if (value instanceof Map) {
            return BridgeJsonHelper.map2Json((Map)value);
        }
        if (value instanceof Collection) {
            return BridgeJsonHelper.coll2Json((Collection)value);
        }
        if (value.getClass().isArray()) {
            return BridgeJsonHelper.array2Json(value);
        }
        return BridgeJsonHelper.customObject2Json(value);
    }

    private static String array2Json(Object array) {
        if (null == array) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int len = Array.getLength(array) - 1;
        if (len > -1) {
            int i;
            for (i = 0; i < len; ++i) {
                sb.append(BridgeJsonHelper.object2JsonString(Array.get(array, i))).append(", ");
            }
            sb.append(BridgeJsonHelper.object2JsonString(Array.get(array, i)));
        }
        sb.append(']');
        return sb.toString();
    }

    private static String coll2Json(Collection<?> coll) {
        if (null == coll) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(BridgeJsonHelper.object2JsonString(it.next()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    private static String customObject2Json(Object obj) {
        Class<?> type = obj.getClass();
        Field[] fields = type.getDeclaredFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field f : fields) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            String name = f.getName();
            f.setAccessible(true);
            Object value = null;
            try {
                value = f.get(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map.put(name, value);
        }
        return BridgeJsonHelper.map2Json(map);
    }

    private static String map2Json(Map<?, ?> map) {
        if (null == map) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, ?> entry = it.next();
            String key = (String)entry.getKey();
            if (null == key) continue;
            sb.append('\"');
            BridgeJsonHelper.escape(key, sb);
            sb.append('\"').append(':').append(BridgeJsonHelper.object2JsonString(entry.getValue()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    private static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        BridgeJsonHelper.escape(s, sb);
        return sb.toString();
    }

    private static void escape(String s, StringBuffer sb) {
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
    }
}

