/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.browser;

import android.content.Context;
import android.os.StatFs;
import android.util.Base64;
import com.tds.common.io.DiskLruCache;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class WebFileCache {
    private static final int MIN_DISK_CACHE_SIZE = 0x1400000;
    private static final int MAX_DISK_CACHE_SIZE = 0x6400000;
    private static WebFileCache INSTANCE;
    private final DiskLruCache diskLruCache;

    WebFileCache(Context context) {
        this.diskLruCache = this.openCache(context);
    }

    public static WebFileCache getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (INSTANCE == null) {
            INSTANCE = new WebFileCache(context);
        }
        return INSTANCE;
    }

    private DiskLruCache openCache(Context context) {
        File cacheDir = new File(context.getCacheDir(), "web_file_cache");
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        long diskCacheSize = this.calculateDiskCacheSize(cacheDir);
        try {
            return DiskLruCache.open(cacheDir, 0, 1, diskCacheSize);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File get(String key) throws IOException {
        String encodeKey = new String(Base64.encode((byte[])key.getBytes(StandardCharsets.UTF_8), (int)10));
        DiskLruCache.Value value = this.diskLruCache.get(encodeKey);
        if (value != null) {
            return value.getFile(0);
        }
        return null;
    }

    private long calculateDiskCacheSize(File dir) {
        long size = 0x1400000L;
        try {
            StatFs statFs = new StatFs(dir.getAbsolutePath());
            long blockCount = statFs.getBlockCountLong();
            long blockSize = statFs.getBlockSizeLong();
            long available = blockCount * blockSize;
            size = available / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Math.max(Math.min(size, 0x6400000L), 0x1400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Writer writer) throws IOException {
        String encodeKey = new String(Base64.encode((byte[])key.getBytes(StandardCharsets.UTF_8), (int)10));
        DiskLruCache.Editor editor = this.diskLruCache.edit(encodeKey);
        try {
            File file = editor.getFile(0);
            if (writer.write(file)) {
                editor.commit();
            }
        }
        finally {
            editor.abortUnlessCommitted();
        }
    }

    public static interface Writer {
        public boolean write(File var1) throws IOException;
    }
}

