/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.net.intercerptor;

import com.tds.common.account.TdsAccount;
import com.tds.common.net.TdsHttp;
import com.tds.common.net.util.HttpUtil;
import java.io.IOException;
import java.util.Map;

public class AuthInterceptor
implements TdsHttp.Interceptor {
    private TDSAccountProvider tdsAccountProvider;

    public AuthInterceptor(TDSAccountProvider tdsAccountProvider) {
        this.tdsAccountProvider = tdsAccountProvider;
    }

    @Override
    public TdsHttp.Response intercept(TdsHttp.Interceptor.Chain chain) throws IOException {
        TdsHttp.Request request = chain.request();
        String url = request.url();
        if (this.tdsAccountProvider.getTdsAccount() != null) {
            Map<String, String> authHeaders = HttpUtil.getAuthorizeHeaders(this.tdsAccountProvider.getTdsAccount(), url, request.method());
            chain.request().headers().putAll(authHeaders);
        }
        return chain.proceed(chain.request());
    }

    public static interface TDSAccountProvider {
        public TdsAccount<?> getTdsAccount();
    }
}

