/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.oauth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.tds.common.TapCommon;
import com.tds.common.oauth.models.AuthorizeRequest;
import com.tds.common.oauth.utils.CodeUtil;
import com.tds.common.oauth.utils.RegionUtil;
import com.tds.common.oauth.utils.RequestUtil;

public class AuthorizationPresenter {
    public static final String KEY_REQUEST = "com.taptap.sdk.request";
    public static final String REQ_KEY_CLIENT_ID = "com.taptap.sdk.request.client_id";
    public static final String REQ_KEY_STATE = "com.taptap.sdk.request.state";
    public static final String REQ_KEY_PERMISSIONS = "com.taptap.sdk.request.permissions";
    public static final String REQ_KEY_SDK_VERSION = "com.taptap.sdk.request.sdk_version";
    public static final String REQ_KEY_LOGIN_VERSION = "com.taptap.sdk.request.login_version";
    public static final String REQ_KEY_RESPONSE_TYPE = "com.taptap.sdk.request.response_type";
    public static final String REQ_KEY_REDIRECT_URI = "com.taptap.sdk.request.redirect_uri";
    public static final String REQ_KEY_CODE_CHALLENGE = "com.taptap.sdk.request.code_challenge";
    public static final String REQ_KEY_CODE_CHALLENGE_METHOD = "com.taptap.sdk.request.code_challenge_method";
    public static final String REQ_KEY_SCREEN_PORTRAIT = "com.taptap.sdk.request.screen.portrait";
    public static final String REQ_KEY_INFO = "com.taptap.sdk.request.info";
    private Context context;
    private AuthorizeRequest processAuthorizeRequest = null;
    AuthorizationView view;

    public AuthorizeRequest getProcessAuthorizeRequest() {
        return this.processAuthorizeRequest;
    }

    public AuthorizationPresenter(Context context, AuthorizationView view) {
        this.context = context;
        this.view = view;
    }

    public AuthorizeRequest makeLoginRequest(String[] permissions, String source) {
        AuthorizeRequest request = new AuthorizeRequest(permissions);
        request.setVersionCode("3.16.5");
        request.setInfo(AuthorizeRequest.generateInfo((Activity)this.context, source));
        request.setCodeVerifier(CodeUtil.getCodeVerifier(128));
        RequestUtil.initClientAuthorizeRequest(request);
        this.processAuthorizeRequest = request;
        return request;
    }

    public void authorization(String[] permissions, String source) {
        AuthorizeRequest request = this.makeLoginRequest(permissions, source);
        Intent intent = this.toIntent(request);
        intent.setAction(RegionUtil.getRegionType(TapCommon.getTapConfig().regionType).targetActionName());
        this.view.realAuthorization(intent);
    }

    public boolean checkState(String state) {
        return state != null && state.equals(this.processAuthorizeRequest.getState());
    }

    public Intent toIntent(AuthorizeRequest request) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        intent.putExtra(KEY_REQUEST, bundle);
        bundle.putString(REQ_KEY_CLIENT_ID, TapCommon.getTapConfig().clientId);
        bundle.putStringArray(REQ_KEY_PERMISSIONS, request.getPermissions());
        bundle.putString(REQ_KEY_STATE, request.getState());
        bundle.putString(REQ_KEY_SDK_VERSION, request.getVersionCode());
        bundle.putBoolean(REQ_KEY_SCREEN_PORTRAIT, true);
        bundle.putString(REQ_KEY_INFO, request.getInfo());
        bundle.putString(REQ_KEY_LOGIN_VERSION, request.getLoginVersion());
        bundle.putString(REQ_KEY_RESPONSE_TYPE, request.getResponseType());
        bundle.putString(REQ_KEY_REDIRECT_URI, request.getRedirectUri());
        bundle.putString(REQ_KEY_CODE_CHALLENGE, request.getCodeChallenge());
        bundle.putString(REQ_KEY_CODE_CHALLENGE_METHOD, request.getCodeChallengeMethod());
        return intent;
    }

    public void detach() {
        this.context = null;
    }

    public static interface AuthorizationView {
        public void realAuthorization(Intent var1);
    }
}

