/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.subscriptions;

import com.tds.common.reactor.Subscription;
import com.tds.common.reactor.subscriptions.Subscriptions;
import com.tds.common.reactor.subscriptions.Unsubscribed;
import java.util.concurrent.atomic.AtomicReference;

public final class SequentialSubscription
extends AtomicReference<Subscription>
implements Subscription {
    private static final long serialVersionUID = 995205034283130269L;

    public SequentialSubscription() {
    }

    public SequentialSubscription(Subscription initial) {
        this.lazySet(initial);
    }

    public Subscription current() {
        Subscription current = (Subscription)super.get();
        if (current == Unsubscribed.INSTANCE) {
            return Subscriptions.unsubscribed();
        }
        return current;
    }

    public boolean update(Subscription next) {
        Subscription current;
        do {
            if ((current = (Subscription)this.get()) != Unsubscribed.INSTANCE) continue;
            if (next != null) {
                next.unsubscribe();
            }
            return false;
        } while (!this.compareAndSet(current, next));
        if (current != null) {
            current.unsubscribe();
        }
        return true;
    }

    public boolean replace(Subscription next) {
        Subscription current;
        do {
            if ((current = (Subscription)this.get()) != Unsubscribed.INSTANCE) continue;
            if (next != null) {
                next.unsubscribe();
            }
            return false;
        } while (!this.compareAndSet(current, next));
        return true;
    }

    public boolean updateWeak(Subscription next) {
        Subscription current = (Subscription)this.get();
        if (current == Unsubscribed.INSTANCE) {
            if (next != null) {
                next.unsubscribe();
            }
            return false;
        }
        if (this.compareAndSet(current, next)) {
            return true;
        }
        current = (Subscription)this.get();
        if (next != null) {
            next.unsubscribe();
        }
        return current == Unsubscribed.INSTANCE;
    }

    public boolean replaceWeak(Subscription next) {
        Subscription current = (Subscription)this.get();
        if (current == Unsubscribed.INSTANCE) {
            if (next != null) {
                next.unsubscribe();
            }
            return false;
        }
        if (this.compareAndSet(current, next)) {
            return true;
        }
        current = (Subscription)this.get();
        if (current == Unsubscribed.INSTANCE) {
            if (next != null) {
                next.unsubscribe();
            }
            return false;
        }
        return true;
    }

    @Override
    public void unsubscribe() {
        Subscription current = (Subscription)this.get();
        if (current != Unsubscribed.INSTANCE && (current = (Subscription)this.getAndSet(Unsubscribed.INSTANCE)) != null && current != Unsubscribed.INSTANCE) {
            current.unsubscribe();
        }
    }

    @Override
    public boolean isUnsubscribed() {
        return this.get() == Unsubscribed.INSTANCE;
    }
}

