/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import com.tds.common.reactor.Observable;
import com.tds.common.reactor.Subscriber;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class ActivityUtils {
    public static boolean isActivityNotAlive(Activity activity) {
        return activity == null || activity.isFinishing() || activity.isDestroyed();
    }

    public static boolean isActivityAlive(Activity activity) {
        return !ActivityUtils.isActivityNotAlive(activity);
    }

    @SuppressLint(value={"PrivateApi"})
    public static Observable<Activity> getStackTopActivity() {
        return Observable.create(new Observable.OnSubscribe<Activity>(){

            @Override
            public void call(Subscriber<? super Activity> subscriber) {
                Class<?> activityThreadClass = null;
                try {
                    activityThreadClass = Class.forName("android.app.ActivityThread");
                    Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                    Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
                    activitiesField.setAccessible(true);
                    Map activities = (Map)activitiesField.get(activityThread);
                    if (activities == null) {
                        subscriber.onError(new Throwable("can't get top activity"));
                    }
                    boolean hasResult = false;
                    for (Object activityRecord : activities.values()) {
                        Class<?> activityRecordClass = activityRecord.getClass();
                        Field pausedField = activityRecordClass.getDeclaredField("paused");
                        pausedField.setAccessible(true);
                        if (pausedField.getBoolean(activityRecord)) continue;
                        Field activityField = activityRecordClass.getDeclaredField("activity");
                        activityField.setAccessible(true);
                        Activity activity = (Activity)activityField.get(activityRecord);
                        subscriber.onNext((Activity)activity);
                        hasResult = true;
                        break;
                    }
                    if (hasResult) {
                        subscriber.onCompleted();
                    } else {
                        subscriber.onError(new Throwable("can't get top activity"));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    subscriber.onError(new Throwable("can't get top activity"));
                }
            }
        });
    }
}

