/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.tds.common.utils.UIUtils;
import com.tds.common.widgets.image.NetworkImageView;

public class RoundNetImageView
extends NetworkImageView {
    Paint paint = new Paint();
    Rect rectSrc;
    Rect rectDest;
    int radius = 50;

    public RoundNetImageView(Context context) {
        super(context);
    }

    public RoundNetImageView(Context context, int radius) {
        super(context);
        this.radius = radius;
    }

    public RoundNetImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RoundNetImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable = this.getDrawable();
        if (null != drawable) {
            Bitmap originBitmap = this.getBitmapFromDrawable(drawable);
            Bitmap drawBitmap = this.getRoundBitmapByShader(originBitmap, this.getWidth(), this.getHeight(), this.radius, 0);
            if (this.rectSrc == null) {
                this.rectSrc = new Rect(0, 0, drawBitmap.getWidth(), drawBitmap.getHeight());
            }
            if (this.rectDest == null) {
                this.rectDest = new Rect(0, 0, this.getWidth(), this.getHeight());
            }
            canvas.drawBitmap(drawBitmap, this.rectSrc, this.rectDest, this.paint);
        } else {
            super.onDraw(canvas);
        }
    }

    public void setBitmapAlpha(float alpha) {
        this.paint.reset();
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setAlpha((int)(alpha * 255.0f));
        this.postInvalidate();
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable) {
        int width = drawable.getIntrinsicWidth() > 0 ? drawable.getIntrinsicWidth() : UIUtils.dp2px(this.getContext(), 28.0f);
        int height = drawable.getIntrinsicHeight() > 0 ? drawable.getIntrinsicHeight() : UIUtils.dp2px(this.getContext(), 28.0f);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.draw(canvas);
        return bitmap;
    }

    private Bitmap getRoundBitmapByShader(Bitmap bitmap, int outWidth, int outHeight, int radius, int boarder) {
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float widthScale = (float)outWidth * 1.0f / (float)width;
        float heightScale = (float)outHeight * 1.0f / (float)height;
        Matrix matrix = new Matrix();
        matrix.setScale(widthScale, heightScale);
        Bitmap desBitmap = Bitmap.createBitmap((int)outWidth, (int)outHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(desBitmap);
        Paint paint = new Paint(1);
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        bitmapShader.setLocalMatrix(matrix);
        paint.setShader((Shader)bitmapShader);
        RectF rect = new RectF((float)boarder, (float)boarder, (float)(outWidth - boarder), (float)(outHeight - boarder));
        canvas.drawRoundRect(rect, (float)radius, (float)radius, paint);
        if (boarder > 0) {
            Paint boarderPaint = new Paint(1);
            boarderPaint.setColor(-16711936);
            boarderPaint.setStyle(Paint.Style.STROKE);
            boarderPaint.setStrokeWidth((float)boarder);
            canvas.drawRoundRect(rect, (float)radius, (float)radius, boarderPaint);
        }
        return desBitmap;
    }
}

