/*
 * Decompiled with CFR 0.152.
 */
package tds.com.google.android.material.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import tds.androidx.annotation.NonNull;
import tds.androidx.annotation.RestrictTo;
import tds.androidx.core.view.ViewCompat;
import tds.com.google.android.material.internal.ViewGroupOverlayApi14;
import tds.com.google.android.material.internal.ViewOverlayImpl;
import tds.com.google.android.material.internal.ViewUtils;

class ViewOverlayApi14
implements ViewOverlayImpl {
    protected OverlayViewGroup overlayViewGroup;

    ViewOverlayApi14(Context context, ViewGroup hostView, View requestingView) {
        this.overlayViewGroup = new OverlayViewGroup(context, hostView, requestingView, this);
    }

    static ViewOverlayApi14 createFrom(View view) {
        ViewGroup contentView = ViewUtils.getContentView(view);
        if (contentView != null) {
            int numChildren = contentView.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                View child = contentView.getChildAt(i);
                if (!(child instanceof OverlayViewGroup)) continue;
                return ((OverlayViewGroup)child).viewOverlay;
            }
            return new ViewGroupOverlayApi14(contentView.getContext(), contentView, view);
        }
        return null;
    }

    @Override
    public void add(@NonNull Drawable drawable) {
        this.overlayViewGroup.add(drawable);
    }

    @Override
    public void remove(@NonNull Drawable drawable) {
        this.overlayViewGroup.remove(drawable);
    }

    @SuppressLint(value={"ViewConstructor", "PrivateApi"})
    static class OverlayViewGroup
    extends ViewGroup {
        static Method invalidateChildInParentFastMethod;
        ViewGroup hostView;
        View requestingView;
        ArrayList<Drawable> drawables = null;
        ViewOverlayApi14 viewOverlay;
        private boolean disposed;

        OverlayViewGroup(Context context, ViewGroup hostView, View requestingView, ViewOverlayApi14 viewOverlay) {
            super(context);
            this.hostView = hostView;
            this.requestingView = requestingView;
            this.setRight(hostView.getWidth());
            this.setBottom(hostView.getHeight());
            hostView.addView((View)this);
            this.viewOverlay = viewOverlay;
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            return false;
        }

        public void add(Drawable drawable) {
            this.assertNotDisposed();
            if (this.drawables == null) {
                this.drawables = new ArrayList();
            }
            if (!this.drawables.contains(drawable)) {
                this.drawables.add(drawable);
                this.invalidate(drawable.getBounds());
                drawable.setCallback((Drawable.Callback)this);
            }
        }

        public void remove(Drawable drawable) {
            if (this.drawables != null) {
                this.drawables.remove(drawable);
                this.invalidate(drawable.getBounds());
                drawable.setCallback(null);
                this.disposeIfEmpty();
            }
        }

        protected boolean verifyDrawable(@NonNull Drawable who) {
            return super.verifyDrawable(who) || this.drawables != null && this.drawables.contains(who);
        }

        public void add(View child) {
            this.assertNotDisposed();
            if (child.getParent() instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)child.getParent();
                if (parent != this.hostView && parent.getParent() != null && ViewCompat.isAttachedToWindow((View)parent)) {
                    int[] parentLocation = new int[2];
                    int[] hostViewLocation = new int[2];
                    parent.getLocationOnScreen(parentLocation);
                    this.hostView.getLocationOnScreen(hostViewLocation);
                    ViewCompat.offsetLeftAndRight(child, parentLocation[0] - hostViewLocation[0]);
                    ViewCompat.offsetTopAndBottom(child, parentLocation[1] - hostViewLocation[1]);
                }
                parent.removeView(child);
                if (child.getParent() != null) {
                    parent.removeView(child);
                }
            }
            super.addView(child);
        }

        public void remove(View view) {
            super.removeView(view);
            this.disposeIfEmpty();
        }

        private void assertNotDisposed() {
            if (this.disposed) {
                throw new IllegalStateException("This overlay was disposed already. Please use a new one via ViewGroupUtils.getOverlay()");
            }
        }

        private void disposeIfEmpty() {
            if (this.getChildCount() == 0 && (this.drawables == null || this.drawables.size() == 0)) {
                this.disposed = true;
                this.hostView.removeView((View)this);
            }
        }

        public void invalidateDrawable(@NonNull Drawable drawable) {
            this.invalidate(drawable.getBounds());
        }

        protected void dispatchDraw(Canvas canvas) {
            int[] contentViewLocation = new int[2];
            int[] hostViewLocation = new int[2];
            this.hostView.getLocationOnScreen(contentViewLocation);
            this.requestingView.getLocationOnScreen(hostViewLocation);
            canvas.translate((float)(hostViewLocation[0] - contentViewLocation[0]), (float)(hostViewLocation[1] - contentViewLocation[1]));
            canvas.clipRect(new Rect(0, 0, this.requestingView.getWidth(), this.requestingView.getHeight()));
            super.dispatchDraw(canvas);
            int numDrawables = this.drawables == null ? 0 : this.drawables.size();
            for (int i = 0; i < numDrawables; ++i) {
                this.drawables.get(i).draw(canvas);
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        private void getOffset(int[] offset) {
            int[] contentViewLocation = new int[2];
            int[] hostViewLocation = new int[2];
            this.hostView.getLocationOnScreen(contentViewLocation);
            this.requestingView.getLocationOnScreen(hostViewLocation);
            offset[0] = hostViewLocation[0] - contentViewLocation[0];
            offset[1] = hostViewLocation[1] - contentViewLocation[1];
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        protected ViewParent invalidateChildInParentFast(int left, int top, Rect dirty) {
            if (this.hostView != null && invalidateChildInParentFastMethod != null) {
                try {
                    int[] offset = new int[2];
                    this.getOffset(offset);
                    invalidateChildInParentFastMethod.invoke((Object)this.hostView, left, top, dirty);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
            if (this.hostView != null) {
                dirty.offset(location[0], location[1]);
                if (this.hostView != null) {
                    location[0] = 0;
                    location[1] = 0;
                    int[] offset = new int[2];
                    this.getOffset(offset);
                    dirty.offset(offset[0], offset[1]);
                    return super.invalidateChildInParent(location, dirty);
                }
                this.invalidate(dirty);
            }
            return null;
        }

        static {
            try {
                invalidateChildInParentFastMethod = ViewGroup.class.getDeclaredMethod("invalidateChildInParentFast", Integer.TYPE, Integer.TYPE, Rect.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

