/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.m3839.sdk.common.helper.URLHelper;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AppUtils {
    public static final String SHA1 = "SHA1";

    public static String getSignInfo(Context context) {
        Context context2 = context;
        return AppUtils.getSignatureString(AppUtils.getSignatures(context2, context2.getApplicationContext().getPackageName())[0], SHA1);
    }

    public static Signature[] getSignatures(Context context, String string2) {
        try {
            return context.getPackageManager().getPackageInfo((String)string2, (int)64).signatures;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static String getSignatureString(Signature object, String string2) {
        block9: {
            StringBuilder stringBuilder;
            String string3 = string2;
            object = object.toByteArray();
            string2 = "error!";
            Object object2 = MessageDigest.getInstance(string3);
            if (object2 == null) break block9;
            byte[] byArray = ((MessageDigest)object2).digest((byte[])object);
            object = byArray;
            object2 = stringBuilder;
            stringBuilder = new StringBuilder();
            int n = byArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                Object object3 = object2;
                Signature signature = object[i2];
                ((StringBuilder)object3).append(Integer.toHexString(signature & 0xFF | 0x100).substring(1, 3));
            }
            try {
                string2 = ((StringBuilder)object2).toString();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return string2;
    }

    public static boolean isValidActivity(Activity activity) {
        return !(Build.VERSION.SDK_INT >= 17 ? activity == null || activity.isFinishing() || activity.isDestroyed() : activity == null || activity.isFinishing());
    }

    public static boolean isWeChatAvailable(Context context) {
        return AppUtils.hasInstallPackage(context, "com.tencent.mm");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getAppVersionCode(Context context) {
        context = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        if (Build.VERSION.SDK_INT < 28) return context.versionCode;
        try {
            return context.getLongVersionCode();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return -1L;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static String getVersionName(Context context, String string2) {
        try {
            return context.getPackageManager().getPackageInfo((String)string2, (int)0).versionName;
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Deprecated
    public static boolean checkVersion(Context object, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)(object = AppUtils.getVersionName((Context)object, string2)))) {
            return ((String)object).compareTo(string3) >= 0;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getVersionCode(Context context, String string2) {
        context = context.getPackageManager().getPackageInfo(string2, 0);
        if (Build.VERSION.SDK_INT < 28) return context.versionCode;
        try {
            return context.getLongVersionCode();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return -1L;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static boolean checkHykbTollVersionCode(Context context) {
        return AppUtils.checkVersionCode(context, "com.hykb.yuanshenmap", 46L);
    }

    public static boolean checkVersionCode(Context context, String string2, long l2) {
        return AppUtils.getVersionCode(context, string2) >= l2;
    }

    public static boolean isQuickPlayRuntime(Context object) {
        block9: {
            block8: {
                object = object.getClassLoader().loadClass("android.os.ServiceManager");
                Class[] classArray = new Class[1];
                classArray[0] = String.class;
                Method method = ((Class)object).getDeclaredMethod("getService", classArray);
                method.setAccessible(true);
                object = method.invoke(object, "wifi").getClass().getClassLoader().toString();
                if (((String)object).contains("com.hykb.yuanshenmap")) break block8;
                try {
                    if (!((String)object).contains("com.xmcy.hykb")) break block9;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public static String getDevice() {
        return Build.MODEL;
    }

    public static int getOsVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isValidIntent(Context context, Intent intent) {
        return context.getPackageManager().resolveActivity(intent, 65536) != null;
    }

    public static boolean hasInstallPackage(Context context, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        Context context2 = context;
        context = null;
        try {
            context = context2.getPackageManager().getPackageInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return context != null;
    }

    public static boolean checkInstallPackageExist(Context object, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if ((object = object.getPackageManager().getInstalledPackages(0)) != null) {
            for (int i2 = 0; i2 < object.size(); ++i2) {
                if (!((PackageInfo)object.get((int)i2)).packageName.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static void openUrl(Context context, String string2) {
        Intent intent;
        Intent intent2;
        Intent intent3 = intent2 = intent;
        intent3();
        intent3.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        if (context.getPackageManager().resolveActivity(intent2, 65536) != null) {
            context.startActivity(intent2);
        }
    }

    public static boolean isAppIsInBackground(Context context) {
        boolean bl = true;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (Build.VERSION.SDK_INT > 20) {
            for (String[] stringArray : activityManager.getRunningAppProcesses()) {
                if (stringArray.importance != 100) continue;
                stringArray = stringArray.pkgList;
                int n = stringArray.pkgList.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (!stringArray[i2].equals(context.getPackageName())) continue;
                    bl = false;
                }
            }
        } else if (((ActivityManager.RunningTaskInfo)activityManager.getRunningTasks((int)1).get((int)0)).topActivity.getPackageName().equals(context.getPackageName())) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getHykbVersionCode(Context context) {
        context = context.getPackageManager().getPackageInfo("com.xmcy.hykb", 0);
        if (Build.VERSION.SDK_INT < 28) return context.versionCode;
        try {
            return context.getLongVersionCode();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return -1L;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static boolean checkHykbVersionCode(Context context) {
        return AppUtils.checkHykbVersionCode(context, 237L);
    }

    public static boolean checkHykbVersionCode(Context context, long l2) {
        return AppUtils.getHykbVersionCode(context) >= l2;
    }

    public static void openDownloadHykbApp(Context context) {
        AppUtils.openUrl(context, URLHelper.getHelper().downloadHykbApp());
    }

    public static String getHykbVersionName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)"com.xmcy.hykb", (int)0).versionName;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void killAllProcess(Activity object) {
        if (object == null) {
            return;
        }
        Context context = object.getApplicationContext();
        object.finish();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : ((ActivityManager)context.getSystemService("activity")).getRunningAppProcesses()) {
            if (runningAppProcessInfo.pid == Process.myPid()) continue;
            Process.killProcess((int)runningAppProcessInfo.pid);
        }
    }

    public static String getAppName(Context object) {
        PackageManager packageManager;
        try {
            packageManager = object.getPackageManager();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
        object = packageManager.getPackageInfo((String)object.getPackageName(), (int)0).applicationInfo.loadLabel(packageManager).toString();
        Log.i((String)"AppUtils", (String)("name = " + (String)object));
        return object;
    }

    public static PackageInfo getPackageInfo(Context context, String string2) {
        Context context2 = context;
        context = null;
        try {
            context = context2.getPackageManager().getPackageInfo(string2, 0);
        }
        catch (Exception exception) {}
        return context;
    }
}

