/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.view.richtext;

import android.app.Activity;
import android.graphics.RectF;
import android.os.Build;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.TextView;
import com.m3839.sdk.common.R;

public class BetterLinkMovementMethod
extends LinkMovementMethod {
    private static BetterLinkMovementMethod singleInstance;
    private static final int LINKIFY_NONE = -2;
    private OnLinkClickListener onLinkClickListener;
    private OnLinkLongClickListener onLinkLongClickListener;
    private final RectF touchedLineBounds;
    private boolean isUrlHighlighted;
    private ClickableSpan clickableSpanUnderTouchOnActionDown;
    private int activeTextViewHashcode;
    private LongPressTimer ongoingLongPressTimer;
    private boolean wasLongPressRegistered;

    public static BetterLinkMovementMethod newInstance() {
        return new BetterLinkMovementMethod();
    }

    public static BetterLinkMovementMethod linkify(int n, TextView ... textViewArray) {
        BetterLinkMovementMethod betterLinkMovementMethod = BetterLinkMovementMethod.newInstance();
        int n2 = textViewArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BetterLinkMovementMethod.addLinks(n, betterLinkMovementMethod, textViewArray[i2]);
        }
        return betterLinkMovementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(TextView ... textViewArray) {
        return BetterLinkMovementMethod.linkify(-2, textViewArray);
    }

    public static BetterLinkMovementMethod linkify(int n, ViewGroup viewGroup) {
        BetterLinkMovementMethod betterLinkMovementMethod = BetterLinkMovementMethod.newInstance();
        BetterLinkMovementMethod.rAddLinks(n, viewGroup, betterLinkMovementMethod);
        return betterLinkMovementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(ViewGroup viewGroup) {
        return BetterLinkMovementMethod.linkify(-2, viewGroup);
    }

    public static BetterLinkMovementMethod linkify(int n, Activity activity) {
        activity = (ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        BetterLinkMovementMethod betterLinkMovementMethod = BetterLinkMovementMethod.newInstance();
        BetterLinkMovementMethod.rAddLinks(n, (ViewGroup)activity, betterLinkMovementMethod);
        return betterLinkMovementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(Activity activity) {
        return BetterLinkMovementMethod.linkify(-2, activity);
    }

    public static BetterLinkMovementMethod getInstance() {
        if (singleInstance == null) {
            singleInstance = new BetterLinkMovementMethod();
        }
        return singleInstance;
    }

    public BetterLinkMovementMethod() {
        RectF rectF;
        BetterLinkMovementMethod betterLinkMovementMethod = rectF;
        rectF = new RectF();
        v1.touchedLineBounds = betterLinkMovementMethod;
    }

    private static void rAddLinks(int n, ViewGroup viewGroup, BetterLinkMovementMethod betterLinkMovementMethod) {
        for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
            View view = viewGroup.getChildAt(i2);
            if (view instanceof ViewGroup) {
                BetterLinkMovementMethod.rAddLinks(n, (ViewGroup)view, betterLinkMovementMethod);
                continue;
            }
            if (!(view instanceof TextView)) continue;
            BetterLinkMovementMethod.addLinks(n, betterLinkMovementMethod, (TextView)view);
        }
    }

    private static void addLinks(int n, BetterLinkMovementMethod betterLinkMovementMethod, TextView textView) {
        textView.setMovementMethod((MovementMethod)betterLinkMovementMethod);
        if (n != -2) {
            Linkify.addLinks((TextView)textView, (int)n);
        }
    }

    private void cleanupOnTouchUp(TextView textView) {
        BetterLinkMovementMethod betterLinkMovementMethod = this;
        betterLinkMovementMethod.wasLongPressRegistered = false;
        betterLinkMovementMethod.clickableSpanUnderTouchOnActionDown = null;
        betterLinkMovementMethod.removeUrlHighlightColor(textView);
        betterLinkMovementMethod.removeLongPressCallback(textView);
    }

    public static /* synthetic */ boolean access$002(BetterLinkMovementMethod betterLinkMovementMethod, boolean bl) {
        betterLinkMovementMethod.wasLongPressRegistered = bl;
        return bl;
    }

    public BetterLinkMovementMethod setOnLinkClickListener(OnLinkClickListener onLinkClickListener) {
        if (this != singleInstance) {
            this.onLinkClickListener = onLinkClickListener;
            return this;
        }
        throw new UnsupportedOperationException("Setting a click listener on the instance returned by getInstance() is not supported to avoid memory leaks. Please use newInstance() or any of the linkify() methods instead.");
    }

    public BetterLinkMovementMethod setOnLinkLongClickListener(OnLinkLongClickListener onLinkLongClickListener) {
        if (this != singleInstance) {
            this.onLinkLongClickListener = onLinkLongClickListener;
            return this;
        }
        throw new UnsupportedOperationException("Setting a long-click listener on the instance returned by getInstance() is not supported to avoid memory leaks. Please use newInstance() or any of the linkify() methods instead.");
    }

    public boolean onTouchEvent(final TextView textView, Spannable object, MotionEvent motionEvent) {
        if (this.activeTextViewHashcode != textView.hashCode()) {
            this.activeTextViewHashcode = textView.hashCode();
            textView.setAutoLinkMask(0);
        }
        final ClickableSpan clickableSpan = this.findClickableSpanUnderTouch(textView, (Spannable)object, motionEvent);
        if (motionEvent.getAction() == 0) {
            this.clickableSpanUnderTouchOnActionDown = clickableSpan;
        }
        boolean bl = this.clickableSpanUnderTouchOnActionDown != null;
        switch (motionEvent.getAction()) {
            default: {
                return false;
            }
            case 3: {
                this.cleanupOnTouchUp(textView);
                return false;
            }
            case 2: {
                if (clickableSpan != this.clickableSpanUnderTouchOnActionDown) {
                    this.removeLongPressCallback(textView);
                }
                if (!this.wasLongPressRegistered) {
                    if (clickableSpan != null) {
                        this.highlightUrl(textView, clickableSpan, (Spannable)object);
                    } else {
                        this.removeUrlHighlightColor(textView);
                    }
                }
                return bl;
            }
            case 1: {
                if (!this.wasLongPressRegistered && bl && clickableSpan == this.clickableSpanUnderTouchOnActionDown) {
                    this.dispatchUrlClick(textView, clickableSpan);
                }
                this.cleanupOnTouchUp(textView);
                return bl;
            }
            case 0: 
        }
        if (clickableSpan != null) {
            this.highlightUrl(textView, clickableSpan, (Spannable)object);
        }
        if (bl && this.onLinkLongClickListener != null) {
            LongPressTimer.OnTimerReachedListener onTimerReachedListener;
            object = onTimerReachedListener;
            onTimerReachedListener = new LongPressTimer.OnTimerReachedListener(){

                @Override
                public void onTimerReached() {
                    1 v0 = this_;
                    BetterLinkMovementMethod.access$002(v0.BetterLinkMovementMethod.this, true);
                    v0.textView.performHapticFeedback(0);
                    v0.BetterLinkMovementMethod.this.removeUrlHighlightColor(this_.textView);
                    1 v1 = this_;
                    1 this_ = v1.textView;
                    v0.BetterLinkMovementMethod.this.dispatchUrlLongClick((TextView)this_, v1.clickableSpan);
                }
            };
            this.startTimerForRegisteringLongClick(textView, (LongPressTimer.OnTimerReachedListener)object);
        }
        return bl;
    }

    public ClickableSpan findClickableSpanUnderTouch(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        BetterLinkMovementMethod betterLinkMovementMethod = this;
        MotionEvent motionEvent2 = motionEvent;
        int n = (int)motionEvent2.getX();
        int n2 = (n -= textView.getTotalPaddingLeft()) + textView.getScrollX();
        n = (int)motionEvent2.getY() - textView.getTotalPaddingTop() + textView.getScrollY();
        Layout layout2 = textView.getLayout();
        int n3 = layout2.getLineForVertical(n);
        float f2 = n2;
        int n4 = layout2.getOffsetForHorizontal(n3, f2);
        this.touchedLineBounds.left = layout2.getLineLeft(n3);
        this.touchedLineBounds.top = layout2.getLineTop(n3);
        RectF rectF = this.touchedLineBounds;
        float f3 = layout2.getLineWidth(n3);
        RectF rectF2 = betterLinkMovementMethod.touchedLineBounds;
        rectF.right = f3 + rectF2.left;
        betterLinkMovementMethod.touchedLineBounds.bottom = layout2.getLineBottom(n3);
        if (betterLinkMovementMethod.touchedLineBounds.contains(f2, (float)n)) {
            int n5 = n4;
            for (Object object : spannable.getSpans(n5, n5, ClickableSpan.class)) {
                if (!(object instanceof ClickableSpan)) continue;
                return (ClickableSpan)object;
            }
            return null;
        }
        return null;
    }

    public void highlightUrl(TextView textView, ClickableSpan clickableSpan, Spannable spannable) {
        if (this.isUrlHighlighted) {
            return;
        }
        this.isUrlHighlighted = true;
        int n = spannable.getSpanStart((Object)clickableSpan);
        int n2 = spannable.getSpanEnd((Object)clickableSpan);
        BackgroundColorSpan backgroundColorSpan = null;
        if (Build.VERSION.SDK_INT >= 16) {
            BackgroundColorSpan backgroundColorSpan2;
            backgroundColorSpan = backgroundColorSpan2;
            backgroundColorSpan2 = new BackgroundColorSpan(textView.getHighlightColor());
        }
        spannable.setSpan((Object)backgroundColorSpan, n, n2, 18);
        textView.setTag(R.id.bettermovementmethod_highlight_background_span, (Object)backgroundColorSpan);
        Selection.setSelection((Spannable)spannable, (int)n, (int)n2);
    }

    public void removeUrlHighlightColor(TextView textView) {
        if (!this.isUrlHighlighted) {
            return;
        }
        this.isUrlHighlighted = false;
        Spannable spannable = (Spannable)textView.getText();
        spannable.removeSpan((Object)((BackgroundColorSpan)textView.getTag(R.id.bettermovementmethod_highlight_background_span)));
        Selection.removeSelection((Spannable)spannable);
    }

    public void startTimerForRegisteringLongClick(TextView object, LongPressTimer.OnTimerReachedListener onTimerReachedListener) {
        LongPressTimer longPressTimer;
        TextView textView = object;
        Object object2 = object = longPressTimer;
        object2();
        this.ongoingLongPressTimer = object2;
        longPressTimer.setOnTimerReachedListener(onTimerReachedListener);
        textView.postDelayed((Runnable)this.ongoingLongPressTimer, (long)ViewConfiguration.getLongPressTimeout());
    }

    public void removeLongPressCallback(TextView textView) {
        LongPressTimer longPressTimer = this.ongoingLongPressTimer;
        if (longPressTimer != null) {
            textView.removeCallbacks((Runnable)longPressTimer);
            this.ongoingLongPressTimer = null;
        }
    }

    public void dispatchUrlClick(TextView textView, ClickableSpan object) {
        BetterLinkMovementMethod betterLinkMovementMethod = clickableSpanWithText;
        ClickableSpanWithText clickableSpanWithText = ClickableSpanWithText.ofSpan(textView, (ClickableSpan)object);
        object = betterLinkMovementMethod.onLinkClickListener;
        if (!(object != null && object.onClick(textView, clickableSpanWithText.text()))) {
            clickableSpanWithText.span().onClick((View)textView);
        }
    }

    public void dispatchUrlLongClick(TextView textView, ClickableSpan object) {
        BetterLinkMovementMethod betterLinkMovementMethod = clickableSpanWithText;
        ClickableSpanWithText clickableSpanWithText = ClickableSpanWithText.ofSpan(textView, (ClickableSpan)object);
        object = betterLinkMovementMethod.onLinkLongClickListener;
        if (!(object != null && object.onLongClick(textView, clickableSpanWithText.text()))) {
            clickableSpanWithText.span().onClick((View)textView);
        }
    }

    public static class ClickableSpanWithText {
        private ClickableSpan span;
        private String text;

        public static ClickableSpanWithText ofSpan(TextView object, ClickableSpan clickableSpan) {
            object = (Spanned)object.getText();
            if (clickableSpan instanceof URLSpan) {
                object = ((URLSpan)clickableSpan).getURL();
            } else {
                TextView textView = object;
                int n = object.getSpanStart((Object)clickableSpan);
                object = textView.subSequence(n, textView.getSpanEnd((Object)clickableSpan)).toString();
            }
            return new ClickableSpanWithText(clickableSpan, (String)object);
        }

        public ClickableSpanWithText(ClickableSpan clickableSpan, String string2) {
            this.span = clickableSpan;
            this.text = string2;
        }

        public ClickableSpan span() {
            return this.span;
        }

        public String text() {
            return this.text;
        }
    }

    public static final class LongPressTimer
    implements Runnable {
        private OnTimerReachedListener onTimerReachedListener;

        @Override
        public void run() {
            this.onTimerReachedListener.onTimerReached();
        }

        public void setOnTimerReachedListener(OnTimerReachedListener onTimerReachedListener) {
            this.onTimerReachedListener = onTimerReachedListener;
        }

        public static interface OnTimerReachedListener {
            public void onTimerReached();
        }
    }

    public static interface OnLinkLongClickListener {
        public boolean onLongClick(TextView var1, String var2);
    }

    public static interface OnLinkClickListener {
        public boolean onClick(TextView var1, String var2);
    }
}

