/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.helper;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import com.tencent.vasdolly.reader.ChannelReader;
import com.tencent.vasdolly.reader.IdValueReader;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;

public class ChannelReaderUtil {
    private static final String TAG = "ChannelReaderUtil";
    private static String mChannelCache;

    public static String getChannel(Context context) {
        if (mChannelCache == null) {
            String channel = ChannelReaderUtil.getChannelByV2(context);
            if (channel == null) {
                channel = ChannelReaderUtil.getChannelByV1(context);
            }
            mChannelCache = channel;
        }
        return mChannelCache;
    }

    public static String getChannelByV2(Context context) {
        String apkPath = ChannelReaderUtil.getApkPath(context);
        String channel = ChannelReader.getChannelByV2((File)new File(apkPath));
        Log.i((String)TAG, (String)("getChannelByV2 , channel = " + channel));
        return channel;
    }

    public static String getChannelByV1(Context context) {
        String apkPath = ChannelReaderUtil.getApkPath(context);
        String channel = ChannelReader.getChannelByV1((File)new File(apkPath));
        Log.i((String)TAG, (String)("getChannelByV1 , channel = " + channel));
        return channel;
    }

    public static String getStringValueById(Context context, int id) {
        String apkPath = ChannelReaderUtil.getApkPath(context);
        String value = IdValueReader.getStringValueById((File)new File(apkPath), (int)id);
        Log.i((String)TAG, (String)("id = " + id + " , value = " + value));
        return value;
    }

    public static byte[] getByteValueById(Context context, int id) {
        String apkPath = ChannelReaderUtil.getApkPath(context);
        return IdValueReader.getByteValueById((File)new File(apkPath), (int)id);
    }

    public static Map<Integer, ByteBuffer> getAllIdValueMap(Context context) {
        String apkPath = ChannelReaderUtil.getApkPath(context);
        return IdValueReader.getAllIdValueMap((File)new File(apkPath));
    }

    private static String getApkPath(Context context) {
        String apkPath = null;
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            if (applicationInfo == null) {
                return null;
            }
            apkPath = applicationInfo.sourceDir;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return apkPath;
    }
}

