/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import com.alipay.sdk.app.H5PayCallback;
import com.alipay.sdk.app.PayTask;
import com.alipay.sdk.util.H5PayResultModel;

public class H5PayActivity
extends Activity {
    private static final String TAG = "DouYou";
    private WebView mWebView;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = null;
        try {
            extras = this.getIntent().getExtras();
        }
        catch (Exception e) {
            this.finish();
            return;
        }
        if (extras == null) {
            this.finish();
            return;
        }
        String url = null;
        try {
            url = extras.getString("url");
        }
        catch (Exception e) {
            this.finish();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            Log.i((String)TAG, (String)"onCreate: H5\u652f\u4ed8\uff0c\u5fc5\u987b\u8bbe\u7f6e\u8981\u6253\u5f00\u7684url\u7f51\u7ad9");
        }
        super.requestWindowFeature(1);
        LinearLayout layout = new LinearLayout(this.getApplicationContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        layout.setOrientation(1);
        this.setContentView((View)layout, (ViewGroup.LayoutParams)params);
        this.mWebView = new WebView(this.getApplicationContext());
        params.weight = 1.0f;
        this.mWebView.setVisibility(0);
        layout.addView((View)this.mWebView, (ViewGroup.LayoutParams)params);
        WebSettings settings = this.mWebView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        CookieManager.getInstance().setAcceptCookie(true);
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(this.mWebView, true);
        }
        settings.setDomStorageEnabled(true);
        this.mWebView.setVerticalScrollbarOverlay(true);
        this.mWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
        this.mWebView.loadUrl(url);
        WebView.setWebContentsDebuggingEnabled((boolean)true);
    }

    public void onBackPressed() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        } else {
            this.finish();
        }
    }

    public void finish() {
        super.finish();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mWebView != null) {
            this.mWebView.removeAllViews();
            try {
                this.mWebView.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.mWebView = null;
        }
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(final WebView view, String url) {
            if (!url.startsWith("http") && !url.startsWith("https")) {
                return true;
            }
            PayTask task = new PayTask((Activity)H5PayActivity.this);
            boolean isIntercepted = task.payInterceptorWithUrl(url, true, new H5PayCallback(){

                public void onPayResult(H5PayResultModel result) {
                    switch (result.getResultCode()) {
                        case "9000": {
                            Log.d((String)H5PayActivity.TAG, (String)"9000: \u8ba2\u5355\u652f\u4ed8\u6210\u529f!!!");
                            H5PayActivity.this.finish();
                            break;
                        }
                        case "4000": 
                        case "6001": {
                            Log.d((String)H5PayActivity.TAG, (String)"6001: \u7528\u6237\u4e2d\u9014\u53d6\u6d88!!!");
                            H5PayActivity.this.finish();
                            break;
                        }
                        case "6002": {
                            Log.d((String)H5PayActivity.TAG, (String)"6002: \u5f53\u524d\u7f51\u7edc\u4e0d\u7a33\u5b9a,\u8bf7\u91cd\u65b0\u5c1d\u8bd5!!!");
                            H5PayActivity.this.finish();
                            break;
                        }
                    }
                    final String url = result.getReturnUrl();
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        H5PayActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                view.loadUrl(url);
                            }
                        });
                    }
                }
            });
            if (!isIntercepted) {
                view.loadUrl(url);
            }
            return true;
        }
    }
}

