/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Toast;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;

public class DYUIUtils {
    public static void showToast(Activity activity, String text) {
        Toast.makeText((Context)activity, (CharSequence)text, (int)0).show();
    }

    public static void getandSaveCurrentImage(Activity activity) {
        WindowManager windowManager = activity.getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        int w = display.getWidth();
        int h = display.getHeight();
        Bitmap Bmp = DYUIUtils.getBitmapFromRootView(activity.findViewById(0x1020002).getRootView(), w, h);
        View decorview = activity.getWindow().getDecorView();
        decorview.setDrawingCacheEnabled(true);
        Bmp = decorview.getDrawingCache();
        DYUIUtils.saveImageToGallery((Context)activity, Bmp);
    }

    private static Bitmap getBitmapFromRootView(View mView, int width, int height) {
        Bitmap bitmap = null;
        if (mView != null) {
            mView.clearFocus();
            mView.setPressed(false);
            boolean willNotCache = mView.willNotCacheDrawing();
            mView.setWillNotCacheDrawing(false);
            int color = mView.getDrawingCacheBackgroundColor();
            mView.setDrawingCacheBackgroundColor(0);
            float alpha = mView.getAlpha();
            mView.setAlpha(1.0f);
            if (color != 0) {
                mView.destroyDrawingCache();
            }
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            mView.measure(widthSpec, heightSpec);
            mView.layout(0, 0, width, height);
            mView.buildDrawingCache();
            Bitmap cacheBitmap = mView.getDrawingCache();
            if (cacheBitmap == null) {
                return null;
            }
            bitmap = Bitmap.createBitmap((Bitmap)cacheBitmap);
            mView.setAlpha(alpha);
            mView.destroyDrawingCache();
            mView.setWillNotCacheDrawing(willNotCache);
            mView.setDrawingCacheBackgroundColor(color);
        }
        return bitmap;
    }

    private static void saveImageToGallery(Context context, Bitmap bitmap) {
        String dirName = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) + File.separator + "HGGame";
        File fileDir = new File(dirName);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
        long mImageTime = System.currentTimeMillis();
        long dateSeconds = mImageTime / 1000L;
        String mImageFileName = dateSeconds + ".png";
        String mImageFilePath = dirName + File.separator + mImageFileName;
        int mImageWidth = bitmap.getWidth();
        int mImageHeight = bitmap.getHeight();
        ContentValues values = new ContentValues();
        ContentResolver resolver = context.getContentResolver();
        values.put("_data", mImageFilePath);
        values.put("title", mImageFileName);
        values.put("_display_name", mImageFileName);
        values.put("datetaken", Long.valueOf(mImageTime));
        values.put("date_added", Long.valueOf(dateSeconds));
        values.put("date_modified", Long.valueOf(dateSeconds));
        values.put("mime_type", "image/png");
        values.put("width", Integer.valueOf(mImageWidth));
        values.put("height", Integer.valueOf(mImageHeight));
        Uri uri = resolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        try {
            OutputStream out = resolver.openOutputStream(uri);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, out);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        values.clear();
        values.put("_size", Long.valueOf(new File(mImageFilePath).length()));
        resolver.update(uri, values, null, null);
    }

    public static byte[] compressImage(Bitmap image, int range) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 90;
        while (baos.toByteArray().length / 1024 > range) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
            options -= 10;
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
        byte[] result = baos.toByteArray();
        return result;
    }

    public static byte[] compressImage(String url, int range) {
        byte[] result = null;
        Bitmap bmp = null;
        try {
            bmp = BitmapFactory.decodeStream((InputStream)new URL(url).openStream());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
            int options = 90;
            while (baos.toByteArray().length / 1024 > range) {
                baos.reset();
                bmp.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
                options -= 10;
            }
            ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
            Bitmap thumbBmp = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)150, (int)150, (boolean)true);
            bmp.recycle();
            result = DYUIUtils.bmpToByteArray(thumbBmp, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] bmpToByteArray(Bitmap bmp, boolean needRecycle) {
        int j;
        int i;
        if (bmp.getHeight() > bmp.getWidth()) {
            i = bmp.getWidth();
            j = bmp.getWidth();
        } else {
            i = bmp.getHeight();
            j = bmp.getHeight();
        }
        Bitmap localBitmap = Bitmap.createBitmap((int)i, (int)j, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas localCanvas = new Canvas(localBitmap);
        while (true) {
            localCanvas.drawBitmap(bmp, new Rect(0, 0, i, j), new Rect(0, 0, i, j), null);
            if (needRecycle) {
                bmp.recycle();
            }
            ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
            localBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)localByteArrayOutputStream);
            localBitmap.recycle();
            byte[] arrayOfByte = localByteArrayOutputStream.toByteArray();
            try {
                localByteArrayOutputStream.close();
                return arrayOfByte;
            }
            catch (Exception exception) {
                i = bmp.getHeight();
                j = bmp.getHeight();
                continue;
            }
            break;
        }
    }

    public static void setWindowSize(Activity activity) {
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.gravity = 17;
        if (activity.getResources().getConfiguration().orientation == 2) {
            layoutParams.width = activity.getResources().getDisplayMetrics().widthPixels / 6 * 3;
            layoutParams.height = (int)((double)(activity.getResources().getDisplayMetrics().heightPixels / 3) * 2.6);
        } else {
            layoutParams.width = (int)((double)(activity.getResources().getDisplayMetrics().widthPixels / 3) * 2.5);
            layoutParams.height = (int)((double)(activity.getResources().getDisplayMetrics().heightPixels / 3) * 1.5);
        }
        window.setAttributes(layoutParams);
    }

    public static void setWindowSizeLEFT(Activity activity) {
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.gravity = 3;
        if (activity.getResources().getConfiguration().orientation == 2) {
            layoutParams.width = activity.getResources().getDisplayMetrics().widthPixels / 5 * 3;
            layoutParams.height = activity.getResources().getDisplayMetrics().heightPixels;
        } else {
            layoutParams.width = (int)((double)(activity.getResources().getDisplayMetrics().widthPixels / 3) * 2.5);
            layoutParams.height = activity.getResources().getDisplayMetrics().heightPixels;
        }
        window.setAttributes(layoutParams);
    }

    public static void setWindowSizeWidth(Activity activity, int size) {
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.gravity = 3;
        if (activity.getResources().getConfiguration().orientation == 2) {
            layoutParams.width = size;
            layoutParams.height = activity.getResources().getDisplayMetrics().heightPixels;
        } else {
            layoutParams.width = size;
            layoutParams.height = activity.getResources().getDisplayMetrics().heightPixels;
        }
        window.setAttributes(layoutParams);
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.size() == 0;
    }

    public static final int getWindowsHeight(Activity activity) {
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    public static final int getWindowsWidth(Activity activity) {
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int dip2px2(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int dp2px(Context context, int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }
}

