/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import com.sdk.douyou.DouYou;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import jxp.android.support.v4.content.FileProvider;

public class DownloadApkTool {
    private static DownloadApkTool downloadApkTool;

    private DownloadApkTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadApkTool getInstance() {
        Class<DouYou> clazz = DouYou.class;
        synchronized (DouYou.class) {
            if (downloadApkTool == null) {
                downloadApkTool = new DownloadApkTool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return downloadApkTool;
        }
    }

    public void showDownloadProgressDialog(Context context, final String downloadUrl) {
        ProgressDialog progressDialog = new ProgressDialog(context);
        progressDialog.setTitle((CharSequence)"\u63d0\u793a");
        progressDialog.setMessage((CharSequence)"\u6b63\u5728\u4e0b\u8f7d...");
        progressDialog.setIndeterminate(false);
        progressDialog.setMax(100);
        progressDialog.setCancelable(false);
        progressDialog.setProgressStyle(1);
        progressDialog.setButton(-2, (CharSequence)"\u524d\u5f80\u6d4f\u89c8\u5668\u4e0b\u8f7d", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Uri uri = Uri.parse((String)downloadUrl);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                DouYou.getInstance().context.startActivity(intent);
            }
        });
        progressDialog.show();
        new DownloadAPK(progressDialog).execute(new String[]{downloadUrl});
    }

    private class DownloadAPK
    extends AsyncTask<String, Integer, String> {
        ProgressDialog progressDialog;
        File file;

        public DownloadAPK(ProgressDialog progressDialog) {
            this.progressDialog = progressDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(String ... params) {
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            try {
                int count;
                URL url = new URL(params[0]);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                int fileLength = conn.getContentLength();
                bis = new BufferedInputStream(conn.getInputStream());
                File externalFilesDir = DouYou.getInstance().context.getExternalFilesDir("down");
                if (!externalFilesDir.exists()) {
                    externalFilesDir.mkdir();
                }
                String downPath = externalFilesDir.getAbsolutePath();
                String fileName = downPath + File.separator + System.currentTimeMillis() + ".apk";
                this.file = new File(fileName);
                if (!this.file.exists()) {
                    if (!this.file.getParentFile().exists()) {
                        this.file.getParentFile().mkdirs();
                    }
                    this.file.createNewFile();
                }
                fos = new FileOutputStream(this.file);
                byte[] data = new byte[4096];
                long total = 0L;
                while ((count = bis.read(data)) != -1) {
                    this.publishProgress(new Integer[]{(int)((total += (long)count) * 100L / (long)fileLength)});
                    fos.write(data, 0, count);
                    fos.flush();
                }
                fos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        protected void onProgressUpdate(Integer ... progress) {
            super.onProgressUpdate((Object[])progress);
            this.progressDialog.setProgress(progress[0].intValue());
        }

        protected void onPostExecute(String s) {
            super.onPostExecute((Object)s);
            this.openFile(this.file);
            this.progressDialog.dismiss();
        }

        private void openFile(File file) {
            if (file != null) {
                Intent intent = new Intent("android.intent.action.VIEW");
                if (Build.VERSION.SDK_INT >= 24) {
                    intent.setFlags(1);
                    Uri contentUri = FileProvider.getUriForFile((Context)DouYou.getInstance().context, (String)(DouYou.getInstance().context.getPackageName() + ".fileProvider"), (File)file);
                    intent.setDataAndType(contentUri, "application/vnd.android.package-archive");
                } else {
                    intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
                    intent.setFlags(0x10000000);
                }
                DouYou.getInstance().context.startActivity(intent);
            }
        }
    }
}

