/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.view.clip;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.sdk.douyou.util.FileUtil;
import com.sdk.douyou.util.view.clip.ClipView;
import java.io.IOException;

public class ClipViewLayout
extends RelativeLayout {
    private ImageView imageView;
    private ClipView clipView;
    private float mHorizontalPadding;
    private float mVerticalPadding;
    private Matrix matrix = new Matrix();
    private Matrix savedMatrix = new Matrix();
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private int mode = 0;
    private PointF start = new PointF();
    private PointF mid = new PointF();
    private float oldDist = 1.0f;
    private final float[] matrixValues = new float[9];
    private float minScale;
    private float maxScale = 4.0f;

    public ClipViewLayout(Context context) {
        this(context, null);
    }

    public ClipViewLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClipViewLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void init(Context context, AttributeSet attrs) {
        this.clipView = new ClipView(context);
        this.imageView = new ImageView(context);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.imageView, (ViewGroup.LayoutParams)lp);
        this.addView(this.clipView, (ViewGroup.LayoutParams)lp);
    }

    public void setClipView(final int type, final int clipBorderWidth, final int mHorizontalPadding) {
        this.mHorizontalPadding = mHorizontalPadding;
        ViewTreeObserver viewTreeObserver = this.clipView.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ClipViewLayout.this.clipView.setClipType(type == 1 ? ClipView.ClipType.CIRCLE : ClipView.ClipType.RECTANGLE);
                ClipViewLayout.this.clipView.setClipBorderWidth(clipBorderWidth);
                ClipViewLayout.this.clipView.setmHorizontalPadding(mHorizontalPadding);
            }
        });
    }

    public void setImageSrc(final Uri uri) {
        ViewTreeObserver observer = this.imageView.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ClipViewLayout.this.initSrcPic(uri);
                ClipViewLayout.this.imageView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    public void initSrcPic(Uri uri) {
        Rect rect;
        float scale;
        if (uri == null) {
            return;
        }
        Log.d((String)"evan", (String)("**********clip_view uri*******  " + uri));
        String path = FileUtil.getRealFilePathFromUri(this.getContext(), uri);
        Log.d((String)"evan", (String)("**********clip_view path*******  " + path));
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Bitmap bitmap = ClipViewLayout.decodeSampledBitmap(path, 720, 1280);
        if (bitmap == null) {
            return;
        }
        int rotation = ClipViewLayout.getExifOrientation(path);
        Matrix m = new Matrix();
        m.setRotate((float)rotation);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        if (bitmap.getWidth() >= bitmap.getHeight()) {
            scale = (float)this.imageView.getWidth() / (float)bitmap.getWidth();
            rect = this.clipView.getClipRect();
            this.minScale = (float)rect.height() / (float)bitmap.getHeight();
            if (scale < this.minScale) {
                scale = this.minScale;
            }
        } else {
            scale = (float)this.imageView.getHeight() / (float)bitmap.getHeight();
            rect = this.clipView.getClipRect();
            this.minScale = (float)rect.width() / (float)bitmap.getWidth();
            if (scale < this.minScale) {
                scale = this.minScale;
            }
        }
        this.matrix.postScale(scale, scale);
        int midX = this.imageView.getWidth() / 2;
        int midY = this.imageView.getHeight() / 2;
        int imageMidX = (int)((float)bitmap.getWidth() * scale / 2.0f);
        int imageMidY = (int)((float)bitmap.getHeight() * scale / 2.0f);
        this.matrix.postTranslate((float)(midX - imageMidX), (float)(midY - imageMidY));
        this.imageView.setScaleType(ImageView.ScaleType.MATRIX);
        this.imageView.setImageMatrix(this.matrix);
        this.imageView.setImageBitmap(bitmap);
    }

    public static int getExifOrientation(String filepath) {
        int orientation;
        int degree = 0;
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(filepath);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (exif != null && (orientation = exif.getAttributeInt("Orientation", -1)) != -1) {
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        return degree;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.savedMatrix.set(this.matrix);
                this.start.set(event.getX(), event.getY());
                this.mode = 1;
                break;
            }
            case 5: {
                this.oldDist = this.spacing(event);
                if (!(this.oldDist > 10.0f)) break;
                this.savedMatrix.set(this.matrix);
                this.midPoint(this.mid, event);
                this.mode = 2;
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                this.mode = 0;
                break;
            }
            case 2: {
                float newDist;
                if (this.mode == 1) {
                    this.matrix.set(this.savedMatrix);
                    float dx = event.getX() - this.start.x;
                    float dy = event.getY() - this.start.y;
                    this.mVerticalPadding = this.clipView.getClipRect().top;
                    this.matrix.postTranslate(dx, dy);
                    this.checkBorder();
                } else if (this.mode == 2 && (newDist = this.spacing(event)) > 10.0f) {
                    float scale = newDist / this.oldDist;
                    if (scale < 1.0f) {
                        if (this.getScale() > this.minScale) {
                            this.matrix.set(this.savedMatrix);
                            this.mVerticalPadding = this.clipView.getClipRect().top;
                            this.matrix.postScale(scale, scale, this.mid.x, this.mid.y);
                            while (this.getScale() < this.minScale) {
                                scale = 1.01f;
                                this.matrix.postScale(scale, scale, this.mid.x, this.mid.y);
                            }
                        }
                        this.checkBorder();
                    } else if (this.getScale() <= this.maxScale) {
                        this.matrix.set(this.savedMatrix);
                        this.mVerticalPadding = this.clipView.getClipRect().top;
                        this.matrix.postScale(scale, scale, this.mid.x, this.mid.y);
                    }
                }
                this.imageView.setImageMatrix(this.matrix);
            }
        }
        return true;
    }

    private RectF getMatrixRectF(Matrix matrix) {
        RectF rect = new RectF();
        Drawable d = this.imageView.getDrawable();
        if (null != d) {
            rect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(rect);
        }
        return rect;
    }

    private void checkBorder() {
        RectF rect = this.getMatrixRectF(this.matrix);
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int width = this.imageView.getWidth();
        int height = this.imageView.getHeight();
        if (rect.width() >= (float)width - 2.0f * this.mHorizontalPadding) {
            if (rect.left > this.mHorizontalPadding) {
                deltaX = -rect.left + this.mHorizontalPadding;
            }
            if (rect.right < (float)width - this.mHorizontalPadding) {
                deltaX = (float)width - this.mHorizontalPadding - rect.right;
            }
        }
        if (rect.height() >= (float)height - 2.0f * this.mVerticalPadding) {
            if (rect.top > this.mVerticalPadding) {
                deltaY = -rect.top + this.mVerticalPadding;
            }
            if (rect.bottom < (float)height - this.mVerticalPadding) {
                deltaY = (float)height - this.mVerticalPadding - rect.bottom;
            }
        }
        this.matrix.postTranslate(deltaX, deltaY);
    }

    public final float getScale() {
        this.matrix.getValues(this.matrixValues);
        return this.matrixValues[0];
    }

    private float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    public Bitmap clip() {
        this.imageView.setDrawingCacheEnabled(true);
        this.imageView.buildDrawingCache();
        Rect rect = this.clipView.getClipRect();
        Bitmap cropBitmap = null;
        Bitmap zoomedCropBitmap = null;
        try {
            cropBitmap = Bitmap.createBitmap((Bitmap)this.imageView.getDrawingCache(), (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
            zoomedCropBitmap = ClipViewLayout.zoomBitmap(cropBitmap, 200, 200);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cropBitmap != null) {
            cropBitmap.recycle();
        }
        this.imageView.destroyDrawingCache();
        return zoomedCropBitmap;
    }

    public static Bitmap decodeSampledBitmap(String filePath, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = ClipViewLayout.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int ratio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            int n = ratio = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
            inSampleSize = ratio < 3 ? ratio : ((double)ratio < 6.5 ? 4 : (ratio < 8 ? 8 : ratio));
        }
        return inSampleSize;
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        return newBmp;
    }
}

