/*
 * Decompiled with CFR 0.152.
 */
package jxp.android.support.v4.animation;

import android.view.View;
import java.util.ArrayList;
import java.util.List;
import jxp.android.support.v4.animation.AnimatorListenerCompat;
import jxp.android.support.v4.animation.AnimatorProvider;
import jxp.android.support.v4.animation.AnimatorUpdateListenerCompat;
import jxp.android.support.v4.animation.ValueAnimatorCompat;

class DonutAnimatorCompatProvider
implements AnimatorProvider {
    DonutAnimatorCompatProvider() {
    }

    @Override
    public ValueAnimatorCompat emptyValueAnimator() {
        return new DonutFloatValueAnimator();
    }

    @Override
    public void clearInterpolator(View view) {
    }

    private static class DonutFloatValueAnimator
    implements ValueAnimatorCompat {
        List<AnimatorListenerCompat> mListeners = new ArrayList<AnimatorListenerCompat>();
        List<AnimatorUpdateListenerCompat> mUpdateListeners = new ArrayList<AnimatorUpdateListenerCompat>();
        View mTarget;
        private long mStartTime;
        private long mDuration = 200L;
        private float mFraction = 0.0f;
        private boolean mStarted = false;
        private boolean mEnded = false;
        private Runnable mLoopRunnable = new Runnable(){

            @Override
            public void run() {
                long dt = DonutFloatValueAnimator.this.getTime() - DonutFloatValueAnimator.this.mStartTime;
                float fraction = (float)dt * 1.0f / (float)DonutFloatValueAnimator.this.mDuration;
                if (fraction > 1.0f || DonutFloatValueAnimator.this.mTarget.getParent() == null) {
                    fraction = 1.0f;
                }
                DonutFloatValueAnimator.this.mFraction = fraction;
                DonutFloatValueAnimator.this.notifyUpdateListeners();
                if (DonutFloatValueAnimator.this.mFraction >= 1.0f) {
                    DonutFloatValueAnimator.this.dispatchEnd();
                } else {
                    DonutFloatValueAnimator.this.mTarget.postDelayed(DonutFloatValueAnimator.this.mLoopRunnable, 16L);
                }
            }
        };

        private void notifyUpdateListeners() {
            for (int i = this.mUpdateListeners.size() - 1; i >= 0; --i) {
                this.mUpdateListeners.get(i).onAnimationUpdate(this);
            }
        }

        @Override
        public void setTarget(View view) {
            this.mTarget = view;
        }

        @Override
        public void addListener(AnimatorListenerCompat listener) {
            this.mListeners.add(listener);
        }

        @Override
        public void setDuration(long duration) {
            if (!this.mStarted) {
                this.mDuration = duration;
            }
        }

        @Override
        public void start() {
            if (this.mStarted) {
                return;
            }
            this.mStarted = true;
            this.dispatchStart();
            this.mFraction = 0.0f;
            this.mStartTime = this.getTime();
            this.mTarget.postDelayed(this.mLoopRunnable, 16L);
        }

        private long getTime() {
            return this.mTarget.getDrawingTime();
        }

        private void dispatchStart() {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                this.mListeners.get(i).onAnimationStart(this);
            }
        }

        private void dispatchEnd() {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                this.mListeners.get(i).onAnimationEnd(this);
            }
        }

        private void dispatchCancel() {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                this.mListeners.get(i).onAnimationCancel(this);
            }
        }

        @Override
        public void cancel() {
            if (this.mEnded) {
                return;
            }
            this.mEnded = true;
            if (this.mStarted) {
                this.dispatchCancel();
            }
            this.dispatchEnd();
        }

        @Override
        public void addUpdateListener(AnimatorUpdateListenerCompat animatorUpdateListener) {
            this.mUpdateListeners.add(animatorUpdateListener);
        }

        @Override
        public float getAnimatedFraction() {
            return this.mFraction;
        }
    }
}

