/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.common;

import com.tencent.vasdolly.common.Pair;
import com.tencent.vasdolly.common.verify.ApkSignatureSchemeV2Verifier;
import java.nio.ByteBuffer;

public class ApkSectionInfo {
    public boolean lowMemory = false;
    public long apkSize;
    public Pair<ByteBuffer, Long> contentEntry;
    public Pair<ByteBuffer, Long> schemeV2Block;
    public Pair<ByteBuffer, Long> centralDir;
    public Pair<ByteBuffer, Long> eocd;

    public void checkParamters() throws ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        boolean result;
        if (!this.lowMemory && this.contentEntry == null || this.schemeV2Block == null || this.centralDir == null || this.eocd == null) {
            throw new RuntimeException("ApkSectionInfo paramters is not valid : " + this.toString());
        }
        boolean bl = result = (this.lowMemory || this.contentEntry.getSecond() == 0L && (long)this.contentEntry.getFirst().remaining() + this.contentEntry.getSecond() == this.schemeV2Block.getSecond()) && (long)this.schemeV2Block.getFirst().remaining() + this.schemeV2Block.getSecond() == this.centralDir.getSecond() && (long)this.centralDir.getFirst().remaining() + this.centralDir.getSecond() == this.eocd.getSecond() && (long)this.eocd.getFirst().remaining() + this.eocd.getSecond() == this.apkSize;
        if (!result) {
            throw new RuntimeException("ApkSectionInfo paramters is not valid : " + this.toString());
        }
        this.checkEocdCentralDirOffset();
    }

    public void rewind() {
        if (this.contentEntry != null) {
            this.contentEntry.getFirst().rewind();
        }
        if (this.schemeV2Block != null) {
            this.schemeV2Block.getFirst().rewind();
        }
        if (this.centralDir != null) {
            this.centralDir.getFirst().rewind();
        }
        if (this.eocd != null) {
            this.eocd.getFirst().rewind();
        }
    }

    public void checkEocdCentralDirOffset() throws ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        long centralDirOffset = ApkSignatureSchemeV2Verifier.getCentralDirOffset(this.eocd.getFirst(), this.eocd.getSecond());
        if (centralDirOffset != this.centralDir.getSecond()) {
            throw new RuntimeException("CentralDirOffset mismatch , EocdCentralDirOffset : " + centralDirOffset + ", centralDirOffset : " + this.centralDir.getSecond());
        }
    }

    public String toString() {
        return "lowMemory : " + this.lowMemory + "\n apkSize : " + this.apkSize + "\n contentEntry : " + this.contentEntry + "\n schemeV2Block : " + this.schemeV2Block + "\n centralDir : " + this.centralDir + "\n eocd : " + this.eocd;
    }
}

