/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.util.ResourceUtil;
import java.util.List;

public class ThirstPayWebViewActivity
extends Activity {
    private WebView webView;
    private boolean isPay = false;
    private OrderInfoBean orderInfoBean;

    @SuppressLint(value={"JavascriptInterface"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(ResourceUtil.getLayoutId((Context)this, "douyou_activity_thirst_pay_webview"));
        String pay_channel_url = this.getIntent().getStringExtra("pay_channel_url");
        this.orderInfoBean = (OrderInfoBean)this.getIntent().getExtras().get("orderInfoBean");
        this.webView = (WebView)this.findViewById(ResourceUtil.getId((Context)this, "thirst_pay_webView"));
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.webView.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.addJavascriptInterface((Object)this, "ThirstPatyCallBack");
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.d((String)"baizePay", (String)("url: " + url));
                if (url.startsWith("weixin:")) {
                    if (ThirstPayWebViewActivity.isWxInstall((Context)ThirstPayWebViewActivity.this)) {
                        ThirstPayWebViewActivity.this.isPay = true;
                        ThirstPayWebViewActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                    } else {
                        Toast.makeText((Context)ThirstPayWebViewActivity.this, (CharSequence)"\u8bf7\u5b89\u88c5\u5fae\u4fe1\u540e\u518d\u5c1d\u8bd5\u652f\u4ed8", (int)0).show();
                        ThirstPayWebViewActivity.this.finish();
                    }
                    return true;
                }
                if (url.startsWith("alipays:") || url.startsWith("alipay")) {
                    try {
                        ThirstPayWebViewActivity.this.isPay = true;
                        ThirstPayWebViewActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }
        });
        this.webView.loadUrl(pay_channel_url);
    }

    @JavascriptInterface
    public void closeAndroidWebview() {
        this.finish();
    }

    public static boolean isWxInstall(Context context) {
        PackageManager packageManager = context.getPackageManager();
        List pinfo = packageManager.getInstalledPackages(0);
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); ++i) {
                String pn = ((PackageInfo)pinfo.get((int)i)).packageName;
                if (!pn.equals("com.tencent.mm")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkAliPayInstalled(Context context) {
        Uri uri = Uri.parse((String)"alipays://platformapi/startApp");
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        ComponentName componentName = intent.resolveActivity(context.getPackageManager());
        return componentName != null;
    }

    protected void onDestroy() {
        if (this.isPay) {
            this.orderInfoBean.setCheckTimes(3);
            DouYou.getInstance().setOrders(this.orderInfoBean);
            DouYou.getInstance().CheckOrder(this.orderInfoBean);
        }
        super.onDestroy();
    }
}

