/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.Build;
import android.os.Bundle;
import android.view.Display;
import android.view.MotionEvent;
import android.view.Window;
import android.view.WindowManager;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.activity.DouYouBallFuncActivity;
import com.sdk.douyou.bean.FloatBallPosition;
import com.sdk.douyou.util.ResourceUtil;

public class FloatBallDialog
extends Dialog {
    private final Context mContext;
    private final DouYou douYou;
    private Window window;
    private WindowManager.LayoutParams layoutParams;
    private Point point;
    private int floatWidth;
    private int distX = 0;
    private int distY = 0;

    public FloatBallDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.mContext = context;
        this.douYou = DouYou.getInstance();
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.applyCompat();
        super.onCreate(savedInstanceState);
        this.setCanceledOnTouchOutside(false);
        this.setCancelable(false);
        this.setContentView(ResourceUtil.getLayoutId(this.mContext, "float_ball_dialog"));
        this.floatWidth = (int)(49.0f * this.mContext.getResources().getDisplayMetrics().density + 0.5f);
        WindowManager systemService = (WindowManager)this.mContext.getSystemService("window");
        this.point = new Point();
        Display defaultDisplay = systemService.getDefaultDisplay();
        defaultDisplay.getSize(this.point);
        this.window = this.getWindow();
        assert (this.window != null);
        this.window.addFlags(8);
        this.layoutParams = this.window.getAttributes();
        if (FloatBallPosition.getX() != 0 && FloatBallPosition.getY() != 0) {
            this.layoutParams.x = FloatBallPosition.getX();
            this.layoutParams.y = FloatBallPosition.getY();
        } else {
            this.layoutParams.x = -(this.point.x / 2);
            this.layoutParams.y = -(this.point.y / 6);
        }
        this.window.setFlags(32, 32);
        this.window.setAttributes(this.layoutParams);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        int x = (int)event.getRawX();
        int y = (int)event.getRawY();
        if (action == 0) {
            this.distX = x;
            this.distY = y;
        }
        if (action == 2) {
            int y2;
            int half = this.floatWidth / 2;
            int x2 = this.point.x / 2;
            int x3 = x > x2 ? x - x2 - half : -(x2 - x) - half;
            if (Math.abs(this.distX - Math.abs(x)) > 10) {
                this.layoutParams.x = x3;
                FloatBallPosition.setX(x3);
            }
            int y3 = y > (y2 = this.point.y / 2) ? y - y2 - half : -(y2 - y) - half;
            if (Math.abs(this.distY - Math.abs(y)) > 10) {
                this.layoutParams.y = y3;
                FloatBallPosition.setY(y3);
            }
            this.window.addFlags(8);
            this.window.setAttributes(this.layoutParams);
        }
        if (action == 1 && this.distX == x && this.distY == y) {
            this.dismiss();
            DouYou.getInstance().context.startActivity(new Intent((Context)DouYou.getInstance().context, DouYouBallFuncActivity.class));
        }
        return true;
    }

    private void applyCompat() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        this.getWindow().setFlags(1024, 1024);
    }
}

