/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.fun;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.util.DouYouSDKParams;
import com.sdk.douyou.util.GameCofigUtil;
import com.sdk.douyou.util.LogUtil;
import java.util.Map;

public class DouyouPluginFactory {
    private static DouyouPluginFactory instance;

    public static DouyouPluginFactory getInstance() {
        if (instance == null) {
            instance = new DouyouPluginFactory();
        }
        return instance;
    }

    public Object initPlugin(String pluginName) {
        Class<?> localClass = null;
        try {
            Log.d((String)"DouyouSDK", (String)("The config of the DouyouSDK is support plugin type:" + pluginName));
            LogUtil.debug("The config of the DouyouSDK is support plugin type:" + pluginName);
            localClass = Class.forName(pluginName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        try {
            return localClass.getDeclaredConstructor(Activity.class).newInstance(DouYou.getInstance().context);
        }
        catch (Exception e) {
            try {
                return localClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                e.printStackTrace();
                return null;
            }
        }
    }

    public Bundle getMetaData(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo != null && appInfo.metaData != null) {
                return appInfo.metaData;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtil.debug("metaData\u51fa\u9519");
        }
        return new Bundle();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public DouYouSDKParams getSDKParams(Context context) {
        Map<String, String> configs = GameCofigUtil.getAssetPropConfig(context, "douyou.properties");
        return new DouYouSDKParams(configs);
    }
}

