/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.util.List;
import java.util.UUID;

public class DeviceUtil {
    public static String getAndroidId(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getSystemModel() {
        return Build.MODEL;
    }

    public static String getDeviceBrand() {
        return Build.BRAND;
    }

    public static String getUniquePsuedoID() {
        String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
        String serial = null;
        try {
            serial = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
        catch (Exception exception) {
            serial = "serial";
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
    }

    public static final String getIMEI(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String imei = telephonyManager.getDeviceId();
            if (imei == null) {
                imei = "";
            }
            return imei;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getIMSI(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String imsi = telephonyManager.getSubscriberId();
            if (null == imsi) {
                imsi = "";
            }
            return imsi;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isWeixinAvilible(Context context) {
        PackageManager packageManager = context.getPackageManager();
        List pinfo = packageManager.getInstalledPackages(0);
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); ++i) {
                String pn = ((PackageInfo)pinfo.get((int)i)).packageName;
                if (!pn.equals("com.tencent.mm")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isQQClientAvailable(Context context) {
        PackageManager packageManager = context.getPackageManager();
        List pinfo = packageManager.getInstalledPackages(0);
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); ++i) {
                String pn = ((PackageInfo)pinfo.get((int)i)).packageName;
                if (!pn.equalsIgnoreCase("com.tencent.qqlite") && !pn.equalsIgnoreCase("com.tencent.mobileqq")) continue;
                return true;
            }
        }
        return false;
    }

    public static String getVersionName(Context context) {
        return DeviceUtil.getPackageInfo((Context)context).versionName;
    }

    public static int getVersionCode(Context context) {
        return DeviceUtil.getPackageInfo((Context)context).versionCode;
    }

    private static PackageInfo getPackageInfo(Context context) {
        PackageInfo pi = null;
        try {
            PackageManager pm = context.getPackageManager();
            pi = pm.getPackageInfo(context.getPackageName(), 16384);
            return pi;
        }
        catch (Exception e) {
            e.printStackTrace();
            return pi;
        }
    }
}

