/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.sdk.douyou.util.ResourceUtil;
import com.sdk.douyou.util.view.clip.ClipViewLayout;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class DouYouClipImageActivity
extends Activity
implements View.OnClickListener {
    private static final String TAG = "ClipImageActivity";
    private ClipViewLayout clipViewLayout1;
    private ClipViewLayout clipViewLayout2;
    private TextView back;
    private TextView btnCancel;
    private TextView btnOk;
    private int type;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(ResourceUtil.getLayoutId((Context)this, "douyou_activity_clip_image"));
        this.type = this.getIntent().getIntExtra("type", 1);
        this.initView();
    }

    public void initView() {
        this.clipViewLayout1 = (ClipViewLayout)this.findViewById(ResourceUtil.getId((Context)this, "clipViewLayout1"));
        this.clipViewLayout1.setClipView(1, 2, 10);
        this.clipViewLayout2 = (ClipViewLayout)this.findViewById(ResourceUtil.getId((Context)this, "clipViewLayout2"));
        this.clipViewLayout2.setClipView(2, 2, 10);
        this.back = (TextView)this.findViewById(ResourceUtil.getId((Context)this, "iv_back"));
        this.btnCancel = (TextView)this.findViewById(ResourceUtil.getId((Context)this, "btn_cancel"));
        this.btnOk = (TextView)this.findViewById(ResourceUtil.getId((Context)this, "bt_ok"));
        this.back.setOnClickListener((View.OnClickListener)this);
        this.btnCancel.setOnClickListener((View.OnClickListener)this);
        this.btnOk.setOnClickListener((View.OnClickListener)this);
    }

    protected void onResume() {
        super.onResume();
        if (this.type == 1) {
            this.clipViewLayout1.setVisibility(0);
            this.clipViewLayout2.setVisibility(8);
            this.clipViewLayout1.setImageSrc(this.getIntent().getData());
        } else {
            this.clipViewLayout2.setVisibility(0);
            this.clipViewLayout1.setVisibility(8);
            this.clipViewLayout2.setImageSrc(this.getIntent().getData());
        }
    }

    public void onClick(View v) {
        if (v.getId() == ResourceUtil.getId((Context)this, "iv_back")) {
            this.finish();
        } else if (v.getId() == ResourceUtil.getId((Context)this, "btn_cancel")) {
            this.finish();
        } else if (v.getId() == ResourceUtil.getId((Context)this, "bt_ok")) {
            this.generateUriAndReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUriAndReturn() {
        Bitmap zoomedCropBitmap = this.type == 1 ? this.clipViewLayout1.clip() : this.clipViewLayout2.clip();
        if (zoomedCropBitmap == null) {
            Log.e((String)"android", (String)"zoomedCropBitmap == null");
            return;
        }
        Uri mSaveUri = Uri.fromFile((File)new File(this.getCacheDir(), "cropped_" + System.currentTimeMillis() + ".jpg"));
        if (mSaveUri != null) {
            OutputStream outputStream = null;
            try {
                outputStream = this.getContentResolver().openOutputStream(mSaveUri);
                if (outputStream != null) {
                    zoomedCropBitmap.compress(Bitmap.CompressFormat.JPEG, 90, outputStream);
                }
            }
            catch (IOException ex) {
                Log.e((String)"android", (String)("Cannot open file: " + mSaveUri), (Throwable)ex);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            Intent intent = new Intent();
            intent.setData(mSaveUri);
            this.setResult(-1, intent);
            this.finish();
        }
    }
}

