/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import com.sdk.douyou.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class DouYouSimulatorCheck {
    private static Activity activity = null;
    private int suspectCount = 0;
    private static DouYouSimulatorCheck checkSimulator = null;
    public static StringBuilder whereAdd = new StringBuilder();
    Boolean hasExist = false;
    String name = "";

    public static DouYouSimulatorCheck getInstance() {
        if (checkSimulator == null) {
            checkSimulator = new DouYouSimulatorCheck();
        }
        return checkSimulator;
    }

    public boolean readSysProperty(Context context) {
        activity = (Activity)context;
        String baseBandVersion = this.getSysProperty("gsm.version.baseband");
        if (null == baseBandVersion || baseBandVersion.contains("1.0.0.0") || "".equals(baseBandVersion)) {
            this.suspectCount += 2;
            this.hasExist = true;
        }
        whereAdd.append("\u57fa\u5e26\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        String buildFlavor = this.getSysProperty("ro.build.flavor");
        if (null == buildFlavor || buildFlavor.contains("vbox") || buildFlavor.contains("sdk_gphone") || buildFlavor.contains("x86") || "".equals(buildFlavor)) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("\u6e20\u9053\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        String productBoard = Build.BOARD;
        if (null == productBoard || productBoard.contains("android") || productBoard.contains("goldfish") || "".equals(productBoard)) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("\u82af\u7247\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        LogUtil.debug("suspectCount3=" + this.suspectCount);
        String boardPlatform = this.getSysProperty("ro.board.platform");
        if (null == boardPlatform || boardPlatform.contains("android") || "".equals(boardPlatform)) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("\u82af\u7247\u5e73\u53f0:" + this.hasExist + "\n");
        this.hasExist = false;
        LogUtil.debug("suspectCount4=" + this.suspectCount);
        String hardWare = Build.HARDWARE;
        if (null == hardWare || hardWare.contains("x86") || "".equals(hardWare)) {
            ++this.suspectCount;
            this.hasExist = true;
        } else if (hardWare.toLowerCase().contains("ttvm")) {
            this.suspectCount += 10;
            this.hasExist = true;
        } else if (hardWare.toLowerCase().contains("nox")) {
            this.suspectCount += 10;
            this.hasExist = true;
        }
        whereAdd.append("\u786c\u4ef6\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        if (Build.VERSION.SDK_INT >= 21) {
            for (String cpu : Build.SUPPORTED_ABIS) {
                if (!cpu.contains("x86")) continue;
                ++this.suspectCount;
                this.hasExist = true;
                break;
            }
        }
        whereAdd.append("cpu_abi\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        String filter = this.execute("cat /proc/self/cgroup");
        if (null == filter || "".equals(filter)) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("\u8fdb\u7a0b\u7ec4\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        String cpuinfo = this.getCpuInfo();
        if (cpuinfo.contains("intel") || cpuinfo.contains("amd")) {
            this.suspectCount += 2;
            this.hasExist = true;
        }
        whereAdd.append("cpuinfo\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        if (!this.hasCallUI().booleanValue()) {
            this.suspectCount += 2;
            this.hasExist = true;
        }
        whereAdd.append("\u62e8\u53f7\u754c\u9762\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        this.checkIoPorts();
        this.checkIomem();
        this.checkDevProperties();
        this.checkSysModule();
        this.checkSysBus();
        this.checkSystemLib();
        this.checkLinuxVersion();
        whereAdd.append("\u6307\u6570:" + this.suspectCount + "\n");
        LogUtil.debug(whereAdd.toString());
        return this.suspectCount > 7;
    }

    public String getSysProperty(String name) {
        String data = null;
        try {
            Class<?> sysclass = Class.forName("android.os.SystemProperties");
            data = (String)sysclass.getMethod("get", String.class).invoke(null, name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            data = "Class error";
            LogUtil.debug("android.os.SystemProperties-----ClassNotFoundException");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LogUtil.debug(name + "-----" + "NoSuchMethodException");
            data = "Method error";
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            data = "Method error";
            LogUtil.debug(name + "-----" + "NoSuchMethodException");
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String command) {
        FilterOutputStream bufferedOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Process process = null;
        try {
            String outputStr;
            process = Runtime.getRuntime().exec("sh");
            bufferedOutputStream = new BufferedOutputStream(process.getOutputStream());
            bufferedInputStream = new BufferedInputStream(process.getInputStream());
            bufferedOutputStream.write(command.getBytes());
            ((BufferedOutputStream)bufferedOutputStream).write(10);
            ((BufferedOutputStream)bufferedOutputStream).flush();
            bufferedOutputStream.close();
            process.waitFor();
            String string = outputStr = DouYouSimulatorCheck.getStrFromBufferInputSteam(bufferedInputStream);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (bufferedOutputStream != null) {
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    private static String getStrFromBufferInputSteam(BufferedInputStream bufferedInputStream) {
        if (null == bufferedInputStream) {
            return "";
        }
        int BUFFER_SIZE = 512;
        byte[] buffer = new byte[BUFFER_SIZE];
        StringBuilder result = new StringBuilder();
        try {
            int read;
            do {
                if ((read = bufferedInputStream.read(buffer)) <= 0) continue;
                result.append(new String(buffer, 0, read));
            } while (read >= BUFFER_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private String getCpuInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/proc/cpuinfo"));
            String data = null;
            while ((data = bufferedReader.readLine()) != null) {
                stringBuilder.append(data);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString().toLowerCase();
    }

    private void checkSensor(Context context) {
        if (context != null) {
            SensorManager sm;
            boolean isSupportCameraFlash = context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
            if (!isSupportCameraFlash) {
                ++this.suspectCount;
            }
            if ((sm = (SensorManager)context.getSystemService("sensor")).getDefaultSensor(5) == null) {
                ++this.suspectCount;
                this.hasExist = true;
            }
            whereAdd.append("\u5149\u4f20\u611f\u5668\u4fe1\u606f:" + this.hasExist + "\n");
            this.hasExist = false;
            int sensorSize = sm.getSensorList(-1).size();
            if (sensorSize <= 7) {
                ++this.suspectCount;
                this.hasExist = true;
            }
            whereAdd.append("\u4f20\u611f\u5668\u4e2a\u6570\u5c0f\u4e8e7:" + this.hasExist + "\n");
            this.hasExist = false;
        }
    }

    private Boolean hasCallUI() {
        Boolean callphone = true;
        try {
            Intent intent = new Intent("android.intent.action.DIAL");
            Uri data = Uri.parse((String)"tel:123456");
            intent.setData(data);
            ComponentName componentName = intent.resolveActivity(activity.getPackageManager());
            this.name = componentName.getClassName();
            String[] namelist = this.name.split("\\.");
            if (namelist.length < 2 || "".equals(this.name)) {
                callphone = false;
            }
        }
        catch (Exception e) {
            callphone = false;
        }
        return callphone;
    }

    private String getBuildProp() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/system/build.prop"));
            String data = null;
            while ((data = bufferedReader.readLine()) != null) {
                stringBuilder.append(data + "\n");
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString().toLowerCase();
    }

    private void checkSystemLib() {
        String path = "/system/lib";
        File file = new File(path);
        File[] fileList = file.listFiles();
        if (fileList == null) {
            LogUtil.debug(path + ", check system lib failed");
            return;
        }
        int n = 0;
        File[] fileArray = fileList;
        int n2 = fileArray.length;
        if (n < n2) {
            File libfile = fileArray[n];
            String filename = libfile.getName();
            if (filename.contains("vbox") && filename.contains(".ko")) {
                ++this.suspectCount;
                this.hasExist = true;
            }
            whereAdd.append("system/lib\u4fe1\u606f:" + this.hasExist + "\n");
            this.hasExist = false;
            return;
        }
    }

    private void checkSysBus() {
        String path = "/sys/bus";
        File file = new File(path);
        File busfile = new File(path + "/virtio");
        if (!file.exists() || busfile.exists()) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("sys/bus\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
    }

    private void checkSysModule() {
        String path = "/sys/module";
        File file = new File(path);
        File[] fileList = file.listFiles();
        if (fileList != null) {
            for (File folder : fileList) {
                String name = folder.getName();
                if (!name.contains("vbox") && !name.contains("virtio") && !name.contains("qemu")) continue;
                ++this.suspectCount;
                this.hasExist = true;
                whereAdd.append("sys/module\u4fe1\u606f:" + this.hasExist + "\n");
                this.hasExist = false;
                return;
            }
        }
        whereAdd.append("sys/module\u4fe1\u606f:" + this.hasExist + "\n");
        LogUtil.debug(path + "  failed");
    }

    private void checkDevProperties() {
        String path = "/dev/_properties_";
        String content = this.readFile(path);
        if (!"".equals(content) && (content.contains("qemu") || content.contains("vbox"))) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("dev/properties\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
    }

    private void checkProcInterrupts() {
        String path = "/proc/interrupts";
        String content = this.readFile(path);
        if (!"".equals(content) && (content.contains("hypervisor") || content.contains("goldfish"))) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("proc/interrupts\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
    }

    private void checkIomem() {
        String path = "/proc/iomem";
        String content = this.readFile(path);
        if (!"".equals(content) && (content.contains("goldfish") || content.contains("vbox"))) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("proc/iomem\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
    }

    private void checkIoPorts() {
        String path = "/proc/ioports";
        String content = this.readFile(path);
        if (!"".equals(content) && (content.contains("goldfish") || content.contains("virtio"))) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("proc/ioports\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
    }

    private void checkLinuxVersion() {
        String path = "/proc/version";
        String content = this.readFile(path);
        if (!"".equals(content) && content.contains("x86")) {
            ++this.suspectCount;
            this.hasExist = true;
        }
        whereAdd.append("/proc/version\u4fe1\u606f:" + this.hasExist + "\n");
        this.hasExist = false;
        LogUtil.debug("checkLinuxVersion=" + content);
    }

    public String readFile(String path) {
        File file = new File(path);
        StringBuilder stringBuilder = new StringBuilder();
        if (file.exists()) {
            BufferedReader reader = null;
            FileReader fileReader = null;
            try {
                String content;
                fileReader = new FileReader(file);
                reader = new BufferedReader(fileReader);
                while ((content = reader.readLine()) != null) {
                    stringBuilder.append(content);
                }
                reader.close();
                fileReader.close();
                return stringBuilder.toString();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

