/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.log;

import com.bytedance.applog.log.IAppLogLogger;
import com.bytedance.applog.log.ILogProcessor;
import com.bytedance.applog.log.LogInfo;
import com.bytedance.applog.log.LogProcessorHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractAppLogLogger
implements IAppLogLogger {
    private static final char CHAR_PLACEHOLDER = ' ';
    private String appId;
    private final List<String> loggerTags = new ArrayList<String>();
    private static final Map<String, IAppLogLogger> loggerMap = new ConcurrentHashMap<String, IAppLogLogger>();

    public AbstractAppLogLogger() {
        this.loggerTags.add("logger@" + this.hashCode());
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
        loggerMap.put(appId, this);
        this.debug("Current logger bind to appId {}", appId);
    }

    public static IAppLogLogger getLogger(String appId) {
        return loggerMap.get(appId);
    }

    protected void process(int category, int level, List<String> tags, Throwable throwable, String message, Object ... args) {
        if (LogProcessorHolder.noAnyProcessor()) {
            return;
        }
        LogInfo log = LogInfo.builder().appId(this.appId).category(category).level(level).thread(Thread.currentThread().getName()).throwable(throwable).tags(this.getTags(tags)).message(this.format(message, args)).build();
        LogProcessorHolder.commonProcess(log);
        ILogProcessor appProcessor = LogProcessorHolder.getAppProcessor(this.appId);
        if (null != appProcessor) {
            appProcessor.onLog(log);
        }
    }

    protected List<String> getTags(List<String> tags) {
        if (null != tags && tags.size() > 0) {
            ArrayList<String> all = new ArrayList<String>();
            all.addAll(this.loggerTags);
            all.addAll(tags);
            return all;
        }
        return this.loggerTags;
    }

    protected String format(String textWithPlaceholders, Object ... args) {
        try {
            StringBuilder toStringBuilder = new StringBuilder();
            if (null == args || args.length == 0 || !textWithPlaceholders.contains("{}")) {
                toStringBuilder.append(textWithPlaceholders);
            } else {
                int argsIndex = 0;
                int length = textWithPlaceholders.length();
                for (int i = 0; i < length; ++i) {
                    int next;
                    char first = textWithPlaceholders.charAt(i);
                    int n = next = i < length - 1 ? (int)textWithPlaceholders.charAt(i + 1) : 32;
                    if (first == '{' && next == 125) {
                        if (argsIndex < args.length) {
                            toStringBuilder.append(this.toString(args[argsIndex++]));
                        }
                        ++i;
                        continue;
                    }
                    toStringBuilder.append(first);
                }
            }
            return toStringBuilder.toString();
        }
        catch (Throwable e) {
            return textWithPlaceholders;
        }
    }

    private String toString(Object obj) {
        return null != obj ? obj.toString() : "";
    }
}

