/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.log;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.bytedance.applog.log.AbsSingleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class EventBus
extends Thread
implements Handler.Callback {
    public static AbsSingleton<EventBus> global = new AbsSingleton<EventBus>(){

        @Override
        protected EventBus create(Object ... params) {
            return new EventBus();
        }
    };
    private static final int EMIT_EVENT_MSG = 1;
    private final Map<String, List<Subscription>> subscriptionMap = new ConcurrentHashMap<String, List<Subscription>>();
    private Handler eventHandler;

    public EventBus() {
        this.start();
    }

    public void emit(String event, Object data) {
        if (TextUtils.isEmpty((CharSequence)event) || !this.subscriptionMap.containsKey(event)) {
            return;
        }
        this.emit(new MessageEvent(event, data));
    }

    public void emit(String event, DataFetcher fetcher) {
        if (TextUtils.isEmpty((CharSequence)event) || !this.subscriptionMap.containsKey(event) || null == fetcher) {
            return;
        }
        Object data = fetcher.fetch();
        this.emit(new MessageEvent(event, data));
    }

    public synchronized void listen(String event, Subscription subscription) {
        List<Subscription> subscriptions = this.subscriptionMap.get(event);
        if (null == subscriptions) {
            subscriptions = new ArrayList<Subscription>();
        }
        subscriptions.add(subscription);
        this.subscriptionMap.put(event, subscriptions);
    }

    public synchronized void remove(String event, Subscription subscription) {
        List<Subscription> subscriptions = this.subscriptionMap.get(event);
        if (null == subscriptions || !subscriptions.contains(subscription)) {
            return;
        }
        subscriptions.remove(subscription);
        if (subscriptions.size() == 0) {
            this.subscriptionMap.remove(event);
        } else {
            this.subscriptionMap.put(event, subscriptions);
        }
    }

    @Override
    public void run() {
        super.run();
        Looper.prepare();
        this.eventHandler = new Handler((Handler.Callback)this);
        Looper.loop();
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            this.emitEvent((MessageEvent)msg.obj);
        }
        return true;
    }

    private void emit(MessageEvent event) {
        if (null != this.eventHandler) {
            this.eventHandler.sendMessage(this.eventHandler.obtainMessage(1, (Object)event));
        } else {
            this.emitEvent(event);
        }
    }

    private void emitEvent(MessageEvent message) {
        List<Subscription> subscriptions = this.subscriptionMap.get(message.event);
        if (null == subscriptions) {
            return;
        }
        HashSet localIdSet = new HashSet();
        byte[] responseByte = null;
        try {
            Object responseByteObj;
            if ("applog_event_upload_eid".equals(message.event) && message.data instanceof JSONObject && ((JSONObject)message.data).has("$$EVENT_LOCAL_IDS")) {
                Object ids = ((JSONObject)message.data).opt("$$EVENT_LOCAL_IDS");
                if (ids instanceof Collection) {
                    localIdSet.addAll((Collection)ids);
                }
            } else if ("applog_do_request_end".equals(message.event) && message.data instanceof JSONObject && ((JSONObject)message.data).has("responseByte") && (responseByteObj = ((JSONObject)message.data).opt("responseByte")) instanceof byte[]) {
                responseByte = (byte[])((byte[])responseByteObj).clone();
            }
            for (Subscription sub : subscriptions) {
                if (message.data instanceof JSONObject) {
                    try {
                        JSONObject copy = new JSONObject(message.data.toString());
                        if (!localIdSet.isEmpty()) {
                            copy.put("$$EVENT_LOCAL_IDS", localIdSet);
                        }
                        if (null != responseByte) {
                            copy.put("responseByte", (Object)responseByte);
                        }
                        sub.sub(copy);
                    }
                    catch (JSONException e) {
                        sub.sub(message.data);
                    }
                    continue;
                }
                sub.sub(message.data);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static class MessageEvent {
        String event;
        Object data;

        MessageEvent(String event, Object data) {
            this.event = event;
            this.data = data;
        }
    }

    public static interface DataFetcher {
        public Object fetch();
    }

    public static interface Subscription {
        public void sub(Object var1);
    }
}

