/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.log;

import com.bytedance.applog.log.ILogProcessor;
import com.bytedance.applog.log.LogInfo;
import com.bytedance.applog.log.LogProcessorHolder;
import com.bytedance.applog.log.LoggerImpl;
import java.util.Iterator;
import java.util.List;

public final class GlobalLoggerImpl
extends LoggerImpl {
    @Override
    public void setAppId(String appId) {
        this.warn("You should not set appId on global logger instance", new Object[0]);
    }

    @Override
    protected void process(int category, int level, List<String> tags, Throwable throwable, String message, Object ... args) {
        if (LogProcessorHolder.noAnyProcessor()) {
            return;
        }
        LogInfo log = LogInfo.builder().category(category).level(level).thread(Thread.currentThread().getName()).throwable(throwable).tags(this.getTags(tags)).message(this.format(message, args)).build();
        LogProcessorHolder.commonProcess(log);
        Iterator<ILogProcessor> appProcessorIterator = LogProcessorHolder.getAppProcessors();
        while (appProcessorIterator.hasNext()) {
            appProcessorIterator.next().onLog(log);
        }
    }
}

