/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.fun;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import com.qq.gdt.action.ActionUtils;
import com.qq.gdt.action.GDTAction;
import com.qq.gdt.action.PrivateController;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.adapter.DouYouSDKListenerAdapter;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.bean.RoleInfoBean;
import com.sdk.douyou.data.DouYouDataCollection;
import com.sdk.douyou.listen.DouYouSDKListener;
import com.sdk.douyou.listen.DouyouActivityCallback;
import com.sdk.douyou.util.DeviceUtil;
import com.sdk.douyou.util.DouYouSDKTools;
import com.sdk.douyou.util.LogUtil;
import com.sdk.douyou.util.net.BaLeApi;
import com.sdk.douyou.util.net.DouYouPostAsyncTask;
import org.json.JSONException;
import org.json.JSONObject;

public class GdtManagement {
    private Activity activity;
    private String APPID;
    private String APPName;
    private String Channel;
    private static GdtManagement instance;

    public static GdtManagement getInstance() {
        if (instance == null) {
            instance = new GdtManagement();
        }
        return instance;
    }

    public void initSDK(Activity context) {
        this.activity = context;
        this.getParams(context);
        this.init(context);
    }

    private void getParams(Activity context) {
        this.APPID = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_ID");
        this.APPName = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_NAME");
        this.Channel = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_CHANNEL");
        LogUtil.debug((String)("gdt-APPID: " + this.APPID));
        LogUtil.debug((String)("gdt-APPName: " + this.APPName));
        LogUtil.debug((String)("gdt-Channel: " + this.Channel));
    }

    private void init(Activity context) {
        LogUtil.debug((String)"gdt- sdk-V1.8.8 init: start ");
        GDTAction.init((Context)this.activity, (String)this.APPID, (String)this.APPName, (String)this.Channel);
        GDTAction.setPrivateController((PrivateController)new PrivateController(){

            public boolean isCanUsePhoneState() {
                return false;
            }

            public String getDevImei() {
                return DeviceUtil.getAndroidId((Context)GdtManagement.this.activity);
            }
        });
        BaLeApi.getInstance().channelReport("0", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                LogUtil.debug((String)"gdt- active");
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    int is_report = objdata.optInt("is_report", 0);
                    LogUtil.debug((String)("gdt-active-is_report: " + is_report));
                    if (is_report == 1) {
                        GDTAction.logAction((String)"START_APP");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
        LogUtil.debug((String)"gdt-  sdk init: end");
        DouYou.getInstance().setSDKListener((DouYouSDKListener)new DouYouSDKListenerAdapter(){

            public void onPayResult(int code, OrderInfoBean params) {
                switch (code) {
                    case 10: {
                        LogUtil.debug((String)"gdt- pay success");
                        GdtManagement.this.purchase(params, true);
                        LogUtil.debug((String)"gdt- pay success");
                    }
                }
            }

            public void onResult(int code, String msg) {
                switch (code) {
                    case 41: {
                        LogUtil.debug((String)"gdt- extra data");
                        GdtManagement.this.setUpdateLevel(DouYouDataCollection.getInstance().getRoleInfoBean());
                        LogUtil.debug((String)"gdt- extra data");
                        break;
                    }
                    case 39: {
                        LogUtil.debug((String)"gdt- register success");
                        GdtManagement.this.setRegister("wechat", true);
                        LogUtil.debug((String)"gdt- register success");
                    }
                }
            }
        });
        DouYou.getInstance().setActivityCallback(new DouyouActivityCallback(){

            public void onCreate(Bundle savedInstanceState) {
            }

            public void onStart() {
            }

            public void onPause() {
                LogUtil.debug((String)"gdt- onPause: ");
            }

            public void onResume() {
                LogUtil.debug((String)"gdt- onResume: ");
            }

            public void onStop() {
            }

            public void onDestroy() {
            }

            public void onRestart() {
            }

            public void onBackPressed() {
            }

            public void onNewIntent(Intent newIntent) {
            }

            public void onConfigurationChanged(Configuration newConfig) {
            }

            public void onSaveInstanceState(Bundle paramBundle) {
            }

            public void onActivityResult(int requestCode, int resultCode, Intent data) {
            }

            public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            }

            public void onWindowFocusChanged(boolean paramBoolean) {
            }
        });
    }

    private void setRegister(final String method, boolean is_success) {
        BaLeApi.getInstance().channelReport("1", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                LogUtil.debug((String)"gdt- setRegister");
                LogUtil.debug((String)("gdt- method: " + method));
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    int is_report = objdata.optInt("is_report", 0);
                    LogUtil.debug((String)("gdt- setRegister-is_report: " + is_report));
                    if (is_report == 1) {
                        ActionUtils.onRegister((String)"bale", (boolean)true);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }

    private void purchase(final OrderInfoBean params, final boolean is_success) {
        BaLeApi.getInstance().channelReport("2", params.getXxx(), DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                LogUtil.debug((String)("gdt- purchase: " + is_success));
                LogUtil.debug((String)("gdt- price: " + Double.valueOf(params.getCpOrderMoney().trim()).intValue() + "\u5143"));
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    int is_report = objdata.optInt("is_report", 0);
                    String report_money_str = objdata.optString("float_report_money", "");
                    float report_money = Double.valueOf(report_money_str).floatValue();
                    LogUtil.debug((String)("gdt- purchase-is_report: " + is_report));
                    LogUtil.debug((String)("gdt- purchase-report_money: " + (int)(report_money * 100.0f)));
                    if (is_report == 1) {
                        ActionUtils.onPurchase((String)params.getProductName(), (String)params.getProductName(), (String)params.getProductName(), (int)1, (String)"\u652f\u4ed8", (String)"CNY", (int)((int)(report_money * 100.0f)), (boolean)true);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }

    private void setUpdateLevel(RoleInfoBean data) {
        LogUtil.debug((String)"gdt- setUpdateLevel");
        LogUtil.debug((String)("gdt- dataType: " + data.getType()));
        if (data.getType() == 0) {
            return;
        }
        if (data.getType() == 2) {
            ActionUtils.onCreateRole((String)data.getNickname());
        } else if (data.getType() == 3) {
            ActionUtils.onUpdateLevel((int)Integer.parseInt(data.getLevel()));
        }
        BaLeApi.getInstance().channelReport("3", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }
}

