/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.fun;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import com.kwai.monitor.log.TurboAgent;
import com.kwai.monitor.log.TurboConfig;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.adapter.DouYouSDKListenerAdapter;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.bean.RoleInfoBean;
import com.sdk.douyou.data.DouYouDataCollection;
import com.sdk.douyou.listen.DouYouSDKListener;
import com.sdk.douyou.listen.DouyouActivityCallback;
import com.sdk.douyou.util.DouYouSDKTools;
import com.sdk.douyou.util.LogUtil;
import com.sdk.douyou.util.net.BaLeApi;
import com.sdk.douyou.util.net.DouYouPostAsyncTask;
import org.json.JSONException;
import org.json.JSONObject;

public class KuaiShouManagement {
    private Activity activity;
    private String APPID;
    private String APPName;
    private String Channel;
    private static KuaiShouManagement instance;

    public static KuaiShouManagement getInstance() {
        if (instance == null) {
            instance = new KuaiShouManagement();
        }
        return instance;
    }

    public void initSDK(Activity context) {
        this.activity = context;
        this.getParams(context);
        this.init(context);
    }

    private void getParams(Activity context) {
        this.APPID = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_ID");
        this.APPName = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_NAME");
        this.Channel = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_CHANNEL");
        LogUtil.debug((String)("kuaishou-APPID: " + this.APPID));
        LogUtil.debug((String)("kuaishou-APPName: " + this.APPName));
        LogUtil.debug((String)("kuaishou-Channel: " + this.Channel));
    }

    private void init(Activity context) {
        LogUtil.debug((String)"kuaishou- sdk-V1.0.14 init: start ");
        TurboAgent.init((TurboConfig)TurboConfig.TurboConfigBuilder.create((Context)context).setAppId(this.APPID).setAppName(this.APPName).setAppChannel(this.Channel).setEnableDebug(true).build());
        BaLeApi.getInstance().channelReport("0", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                LogUtil.debug((String)"kuaishou- active");
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    int is_report = objdata.optInt("is_report", 0);
                    LogUtil.debug((String)("kuaishou-active-is_report: " + is_report));
                    if (is_report == 1) {
                        TurboAgent.onAppActive();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
        LogUtil.debug((String)"kuaishou-  sdk init: end");
        DouYou.getInstance().setSDKListener((DouYouSDKListener)new DouYouSDKListenerAdapter(){

            public void onPayResult(int code, OrderInfoBean params) {
                switch (code) {
                    case 10: {
                        LogUtil.debug((String)"kuaishou- pay success");
                        KuaiShouManagement.this.purchase(params, true);
                        LogUtil.debug((String)"kuaishou- pay success");
                    }
                }
            }

            public void onResult(int code, String msg) {
                switch (code) {
                    case 41: {
                        LogUtil.debug((String)"kuaishou- extra data");
                        KuaiShouManagement.this.setUpdateLevel(DouYouDataCollection.getInstance().getRoleInfoBean());
                        LogUtil.debug((String)"kuaishou- toutiao extra data");
                        break;
                    }
                    case 39: {
                        LogUtil.debug((String)"kuaishou- register success");
                        KuaiShouManagement.this.setRegister("wechat", true);
                        LogUtil.debug((String)"kuaishou- toutiao register success");
                    }
                }
            }
        });
        DouYou.getInstance().setActivityCallback(new DouyouActivityCallback(){

            public void onCreate(Bundle savedInstanceState) {
            }

            public void onStart() {
            }

            public void onPause() {
                LogUtil.debug((String)"kuaishou- onPause: ");
                TurboAgent.onPagePause();
            }

            public void onResume() {
                LogUtil.debug((String)"kuaishou- onResume: ");
                TurboAgent.onPageResume();
            }

            public void onStop() {
            }

            public void onDestroy() {
            }

            public void onRestart() {
            }

            public void onBackPressed() {
            }

            public void onNewIntent(Intent newIntent) {
            }

            public void onConfigurationChanged(Configuration newConfig) {
            }

            public void onSaveInstanceState(Bundle paramBundle) {
            }

            public void onActivityResult(int requestCode, int resultCode, Intent data) {
            }

            public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            }

            public void onWindowFocusChanged(boolean paramBoolean) {
            }
        });
    }

    private void setRegister(final String method, boolean is_success) {
        BaLeApi.getInstance().channelReport("1", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                LogUtil.debug((String)"kuaishou- setRegister");
                LogUtil.debug((String)("kuaishou- method: " + method));
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    int is_report = objdata.optInt("is_report", 0);
                    LogUtil.debug((String)("kuaishou- setRegister-is_report: " + is_report));
                    if (is_report == 1) {
                        TurboAgent.onRegister();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }

    private void purchase(final OrderInfoBean params, final boolean is_success) {
        BaLeApi.getInstance().channelReport("2", params.getXxx(), DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
                LogUtil.debug((String)("kuaishou- purchase: " + is_success));
                LogUtil.debug((String)("kuaishou- price: " + Double.valueOf(params.getCpOrderMoney().trim()).intValue() + "\u5143"));
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    int is_report = objdata.optInt("is_report", 0);
                    String report_money_str = objdata.optString("float_report_money", "");
                    float report_money = Double.valueOf(report_money_str).floatValue();
                    LogUtil.debug((String)("kuaishou- purchase-is_report: " + is_report));
                    LogUtil.debug((String)("kuaishou- purchase-report_money: " + report_money));
                    if (is_report == 1) {
                        TurboAgent.onPay((double)report_money);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }

    private void setUpdateLevel(RoleInfoBean data) {
        LogUtil.debug((String)"kuaishou- setUpdateLevel");
        LogUtil.debug((String)("kuaishou- dataType: " + data.getType()));
        if (data.getType() == 0) {
            return;
        }
        if (data.getType() == 2) {
            TurboAgent.onGameCreateRole((String)data.getNickname());
        } else if (data.getType() == 3) {
            TurboAgent.onGameUpgradeRole((int)Integer.parseInt(data.getLevel()));
        }
        BaLeApi.getInstance().channelReport("3", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
            }

            public void Fail(String error) {
                LogUtil.debug((String)error);
            }
        });
    }
}

