/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.aggregation;

import com.bytedance.applog.aggregation.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001J(\u0010+\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010,\u001a\u00020\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006-"}, d2={"Lcom/bytedance/applog/aggregation/Metrics;", "", "name", "", "groupId", "aggregationTypes", "", "startTime", "", "params", "Lorg/json/JSONObject;", "interval", "(Ljava/lang/String;Ljava/lang/String;IJLorg/json/JSONObject;Ljava/lang/String;)V", "getAggregationTypes", "()I", "<set-?>", "count", "getCount", "endTime", "getEndTime", "()J", "setEndTime", "(J)V", "getGroupId", "()Ljava/lang/String;", "getInterval", "getName", "getParams", "()Lorg/json/JSONObject;", "getStartTime", "", "sum", "getSum", "()D", "values", "Lorg/json/JSONArray;", "getValues", "()Lorg/json/JSONArray;", "setValues", "(Lorg/json/JSONArray;)V", "append", "", "value", "restore", "toParams", "aggregation_release"})
public final class Metrics {
    private int count;
    private double sum;
    private long endTime;
    @Nullable
    private JSONArray values;
    @NotNull
    private final String name;
    @NotNull
    private final String groupId;
    private final int aggregationTypes;
    private final long startTime;
    @Nullable
    private final JSONObject params;
    @Nullable
    private final String interval;

    public final int getCount() {
        return this.count;
    }

    public final double getSum() {
        return this.sum;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public final void setEndTime(long l) {
        this.endTime = l;
    }

    @Nullable
    public final JSONArray getValues() {
        return this.values;
    }

    public final void setValues(@Nullable JSONArray jSONArray) {
        this.values = jSONArray;
    }

    public final void restore(int count, double sum, long endTime, @Nullable JSONArray values) {
        this.count = count;
        this.sum = sum;
        this.endTime = endTime;
        this.values = values;
    }

    public final void append(@Nullable Object value) {
        int n = this.count;
        this.count = n + 1;
        if ((this.aggregationTypes & 2) > 0 && value instanceof Number) {
            this.sum += ((Number)value).doubleValue();
        }
        if ((this.aggregationTypes & 8) > 0) {
            if (this.values == null) {
                this.values = new JSONArray();
            }
            JSONArray jSONArray = this.values;
            if (jSONArray != null) {
                jSONArray.put(value);
            }
        }
        this.endTime = System.currentTimeMillis();
    }

    @NotNull
    public final JSONObject toParams() {
        JSONObject jSONObject = UtilsKt.copyFrom(new JSONObject(), this.params);
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("metrics_start_ms", this.startTime);
        $this$apply.put("metrics_end_ms", this.endTime);
        $this$apply.put("metrics_aggregation", this.aggregationTypes);
        $this$apply.put("metrics_count", this.count);
        if ((this.aggregationTypes & 2) > 0) {
            $this$apply.put("metrics_sum", this.sum);
        }
        if ((this.aggregationTypes & 4) > 0) {
            $this$apply.put("metrics_avg", this.sum / (double)this.count);
        }
        if ((this.aggregationTypes & 8) > 0) {
            $this$apply.put("metrics_values", (Object)this.values);
        }
        if ((this.aggregationTypes & 0x10) > 0) {
            $this$apply.put("metrics_interval", (Object)this.interval);
        }
        return jSONObject;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    public final int getAggregationTypes() {
        return this.aggregationTypes;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    @Nullable
    public final JSONObject getParams() {
        return this.params;
    }

    @Nullable
    public final String getInterval() {
        return this.interval;
    }

    public Metrics(@NotNull String name, @NotNull String groupId, int aggregationTypes, long startTime, @Nullable JSONObject params, @Nullable String interval) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        this.name = name;
        this.groupId = groupId;
        this.aggregationTypes = aggregationTypes;
        this.startTime = startTime;
        this.params = params;
        this.interval = interval;
        this.endTime = this.startTime;
    }
}

