/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.aggregation;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.bytedance.applog.aggregation.IMetricsCache;
import com.bytedance.applog.aggregation.Metrics;
import com.bytedance.applog.aggregation.MetricsMemoryCache;
import com.bytedance.applog.aggregation.MetricsSQLiteOpenHelper;
import com.bytedance.applog.aggregation.UtilsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bytedance/applog/aggregation/MetricsSQLiteCache;", "Lcom/bytedance/applog/aggregation/IMetricsCache;", "context", "Landroid/content/Context;", "dbName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "memCache", "Lcom/bytedance/applog/aggregation/MetricsMemoryCache;", "openHelper", "Lcom/bytedance/applog/aggregation/MetricsSQLiteOpenHelper;", "clear", "", "fillMetrics", "Lcom/bytedance/applog/aggregation/Metrics;", "cursor", "Landroid/database/Cursor;", "get", "groupId", "getAll", "", "getByMetricsName", "name", "insert", "metrics", "update", "aggregation_release"})
public final class MetricsSQLiteCache
implements IMetricsCache {
    private final MetricsSQLiteOpenHelper openHelper;
    private final MetricsMemoryCache memCache;

    @Override
    @Nullable
    public Metrics get(@NotNull String groupId) {
        Cursor cursor;
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Metrics metrics = this.memCache.get(groupId);
        if (metrics == null && (cursor = this.openHelper.getReadableDatabase().rawQuery("SELECT * FROM metrics WHERE group_id = ?", new String[]{groupId})).moveToNext()) {
            Cursor cursor2 = cursor;
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            metrics = this.fillMetrics(cursor2);
            this.memCache.insert(groupId, metrics);
        }
        return metrics;
    }

    private final Metrics fillMetrics(Cursor cursor) {
        String name = cursor.getString(cursor.getColumnIndex("name"));
        String groupId = cursor.getString(cursor.getColumnIndex("group_id"));
        int types = cursor.getInt(cursor.getColumnIndex("agg_types"));
        long startTime = cursor.getLong(cursor.getColumnIndex("start_time"));
        String string = cursor.getString(cursor.getColumnIndex("params"));
        JSONObject params = string != null ? UtilsKt.toJSONObject(string) : null;
        String interval = cursor.getString(cursor.getColumnIndex("interval"));
        int count = cursor.getInt(cursor.getColumnIndex("count"));
        double sum = cursor.getDouble(cursor.getColumnIndex("sum"));
        long endTime = cursor.getLong(cursor.getColumnIndex("end_time"));
        String string2 = cursor.getString(cursor.getColumnIndex("value_array"));
        JSONArray valueArray = string2 != null ? UtilsKt.toJSONArray(string2) : null;
        String string3 = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
        String string4 = groupId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"groupId");
        Metrics metrics = new Metrics(string3, string4, types, startTime, params, interval);
        metrics.restore(count, sum, endTime, valueArray);
        return metrics;
    }

    @Override
    public void insert(@NotNull String groupId, @NotNull Metrics metrics) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)metrics, (String)"metrics");
        ContentValues values = new ContentValues();
        values.put("name", metrics.getName());
        values.put("group_id", metrics.getGroupId());
        values.put("agg_types", Integer.valueOf(metrics.getAggregationTypes()));
        values.put("start_time", Long.valueOf(metrics.getStartTime()));
        JSONObject jSONObject = metrics.getParams();
        values.put("params", jSONObject != null ? jSONObject.toString() : null);
        values.put("interval", metrics.getInterval());
        values.put("count", Integer.valueOf(metrics.getCount()));
        values.put("sum", Double.valueOf(metrics.getSum()));
        values.put("end_time", Long.valueOf(metrics.getEndTime()));
        values.put("value_array", String.valueOf(metrics.getValues()));
        this.openHelper.getWritableDatabase().insert("metrics", null, values);
        this.memCache.insert(groupId, metrics);
    }

    @Override
    public void update(@NotNull String groupId, @NotNull Metrics metrics) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)metrics, (String)"metrics");
        ContentValues values = new ContentValues();
        values.put("count", Integer.valueOf(metrics.getCount()));
        values.put("sum", Double.valueOf(metrics.getSum()));
        values.put("end_time", Long.valueOf(metrics.getEndTime()));
        values.put("value_array", String.valueOf(metrics.getValues()));
        this.openHelper.getWritableDatabase().update("metrics", values, "group_id = ?", new String[]{groupId});
        this.memCache.update(groupId, metrics);
    }

    @Override
    @NotNull
    public List<Metrics> getAll() {
        Cursor cursor = this.openHelper.getReadableDatabase().rawQuery("SELECT * FROM metrics", null);
        boolean bl = false;
        List list = new ArrayList();
        while (cursor.moveToNext()) {
            Cursor cursor2 = cursor;
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            list.add(this.fillMetrics(cursor2));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Metrics> getByMetricsName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Cursor cursor = this.openHelper.getReadableDatabase().rawQuery("SELECT * FROM metrics WHERE name = ?", new String[]{name});
        boolean bl = false;
        List list = new ArrayList();
        while (cursor.moveToNext()) {
            Cursor cursor2 = cursor;
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            list.add(this.fillMetrics(cursor2));
        }
        return list;
    }

    @Override
    public void clear() {
        this.openHelper.getWritableDatabase().delete("metrics", null, null);
        this.memCache.clear();
    }

    public MetricsSQLiteCache(@NotNull Context context, @NotNull String dbName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)dbName, (String)"dbName");
        this.openHelper = new MetricsSQLiteOpenHelper(context, dbName);
        this.memCache = new MetricsMemoryCache();
    }
}

