/*
 * Decompiled with CFR 0.152.
 */
package com.zui.opendeviceidlibrary;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.zui.deviceidservice.IDeviceidInterface;

public class OpenDeviceId {
    private static String TAG = "OpenDeviceId library";
    private static boolean DBG = false;
    private Context mContext = null;
    private IDeviceidInterface mDeviceidInterface;
    private ServiceConnection mConnection;
    private CallBack mCallerCallBack = null;

    private void logPrintI(String string) {
    }

    private void logPrintE(String string) {
    }

    public static /* synthetic */ IDeviceidInterface access$002(OpenDeviceId openDeviceId, IDeviceidInterface iDeviceidInterface) {
        openDeviceId.mDeviceidInterface = iDeviceidInterface;
        return iDeviceidInterface;
    }

    public int init(Context context, CallBack<String> callBack) {
        if (context != null) {
            Intent intent;
            this.mContext = context;
            this.mCallerCallBack = callBack;
            this.mConnection = new ServiceConnection(){

                public synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                    1 v0 = this;
                    OpenDeviceId.access$002(v0.OpenDeviceId.this, IDeviceidInterface.Stub.asInterface(iBinder));
                    if (v0.OpenDeviceId.this.mCallerCallBack != null) {
                        OpenDeviceId.this.mCallerCallBack.serviceConnected("Deviceid Service Connected", OpenDeviceId.this);
                    }
                    OpenDeviceId.this.logPrintI("Service onServiceConnected");
                }

                public void onServiceDisconnected(ComponentName componentName) {
                    1 v0 = this;
                    OpenDeviceId.access$002(v0.OpenDeviceId.this, null);
                    v0.OpenDeviceId.this.logPrintI("Service onServiceDisconnected");
                }
            };
            context = intent;
            new Intent().setClassName("com.zui.deviceidservice", "com.zui.deviceidservice.DeviceidService");
            if (this.mContext.bindService((Intent)context, this.mConnection, 1)) {
                this.logPrintI("bindService Successful!");
                return 1;
            }
            this.logPrintI("bindService Failed!");
            return -1;
        }
        throw new NullPointerException("Context can not be null.");
    }

    public String getOAID() {
        if (this.mContext != null) {
            block4: {
                IDeviceidInterface iDeviceidInterface = this.mDeviceidInterface;
                if (iDeviceidInterface == null) break block4;
                try {
                    return iDeviceidInterface.getOAID();
                }
                catch (RemoteException remoteException) {
                    this.logPrintE("getOAID error, RemoteException!");
                    remoteException.printStackTrace();
                }
            }
            return null;
        }
        this.logPrintE("Context is null.");
        throw new IllegalArgumentException("Context is null, must be new OpenDeviceId first");
    }

    public String getUDID() {
        if (this.mContext != null) {
            block5: {
                IDeviceidInterface iDeviceidInterface = this.mDeviceidInterface;
                if (iDeviceidInterface == null) break block5;
                try {
                    return iDeviceidInterface.getUDID();
                }
                catch (Exception exception) {
                    this.logPrintE("getUDID error, Exception!");
                    exception.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    this.logPrintE("getUDID error, RemoteException!");
                    remoteException.printStackTrace();
                }
            }
            return null;
        }
        this.logPrintE("Context is null.");
        throw new IllegalArgumentException("Context is null, must be new OpenDeviceId first");
    }

    public boolean isSupported() {
        block3: {
            try {
                if (this.mDeviceidInterface == null) break block3;
            }
            catch (RemoteException remoteException) {
                this.logPrintE("isSupport error, RemoteException!");
                return false;
            }
            OpenDeviceId openDeviceId = this;
            openDeviceId.logPrintI("Device support opendeviceid");
            return openDeviceId.mDeviceidInterface.isSupport();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getVAID() {
        Object object = this.mContext;
        if (object != null) {
            object = object.getPackageName();
            this.logPrintI("liufeng, getVAID package\uff1a" + (String)object);
            if (object != null && !((String)object).equals("")) {
                IDeviceidInterface iDeviceidInterface;
                try {
                    iDeviceidInterface = this.mDeviceidInterface;
                    if (iDeviceidInterface == null) return null;
                }
                catch (RemoteException remoteException) {
                    this.logPrintE("getVAID error, RemoteException!");
                    remoteException.printStackTrace();
                    return null;
                }
                return iDeviceidInterface.getVAID((String)object);
            } else {
                this.logPrintI("input package is null!");
            }
            return null;
        }
        this.logPrintI("Context is null.");
        throw new IllegalArgumentException("Context is null, must be new OpenDeviceId first");
    }

    public String getAAID() {
        Object object = this.mContext;
        if (object != null) {
            String string;
            block9: {
                object = object.getPackageName();
                this.logPrintI("liufeng, getAAID package\uff1a" + (String)object);
                string = null;
                if (object != null && !((String)object).equals("")) {
                    block10: {
                        IDeviceidInterface iDeviceidInterface = this.mDeviceidInterface;
                        if (iDeviceidInterface == null) break block9;
                        string = iDeviceidInterface.getAAID((String)object);
                        if (string == null) break block10;
                        if (!"".equals(string)) break block9;
                    }
                    if (!this.mDeviceidInterface.createAAIDForPackageName((String)object)) break block9;
                    try {
                        string = this.mDeviceidInterface.getAAID((String)object);
                    }
                    catch (RemoteException remoteException) {
                        this.logPrintE("getAAID error, RemoteException!");
                    }
                } else {
                    this.logPrintI("input package is null!");
                }
            }
            return string;
        }
        this.logPrintI("Context is null.");
        throw new IllegalArgumentException("Context is null, must be new OpenDeviceId first");
    }

    public void shutdown() {
        try {
            OpenDeviceId openDeviceId = this;
            openDeviceId.mContext.unbindService(this.mConnection);
            openDeviceId.logPrintI("unBind Service successful");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logPrintE("unBind Service exception");
        }
        this.mDeviceidInterface = null;
    }

    public void setLogEnable(boolean bl) {
        DBG = bl;
    }

    public static interface CallBack<T> {
        public void serviceConnected(T var1, OpenDeviceId var2);
    }
}

