/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.DouYouManage;
import com.sdk.douyou.activity.DouYouPointLoginActivity;
import com.sdk.douyou.bean.LoginSuccessBean;
import com.sdk.douyou.bean.UserInfoBean;
import com.sdk.douyou.util.ResourceUtil;
import com.sdk.douyou.util.SpUtil;
import com.sdk.douyou.util.net.BaLeApi;
import com.sdk.douyou.util.net.DouYouPostAsyncTask;
import org.json.JSONException;
import org.json.JSONObject;

public class DouYouQuickLoginDialog
extends DialogFragment
implements View.OnClickListener {
    private Activity context;
    private LinearLayout dy_dialog_quick_login_LL;
    private TextView dy_dialog_quick_login_account;
    private Handler mHandler;
    private UserInfoBean userInfoBean;
    private TextView dy_dialog_quick_login_switch;
    private ProgressBar dy_dialog_quick_login_progress;
    private TextView dy_dialog_quick_login_text;
    private CountDownTimer countDownTimer = new CountDownTimer(3000L, 1000L){

        public void onTick(long millisUntilFinished) {
            if (millisUntilFinished <= 1000L) {
                DouYouQuickLoginDialog.this.dy_dialog_quick_login_LL.setClickable(false);
            }
        }

        public void onFinish() {
            DouYouQuickLoginDialog.this.LoginGoing(DouYouQuickLoginDialog.this.userInfoBean.getUsername(), DouYouQuickLoginDialog.this.userInfoBean.getPassword());
        }
    };

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.setStyle(2, ResourceUtil.getStyleId((Context)activity, "dy_theme"));
        this.context = activity;
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        dialog.getWindow().setGravity(48);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setCancelable(false);
        this.getDialog().setCanceledOnTouchOutside(false);
        View view = inflater.inflate(ResourceUtil.getLayoutId((Context)this.context, "douyou_quick_login_dialog"), container);
        this.dy_dialog_quick_login_LL = (LinearLayout)view.findViewById(ResourceUtil.getId((Context)this.context, "dy_dialog_quick_login_LL"));
        this.dy_dialog_quick_login_LL.setOnClickListener((View.OnClickListener)this);
        this.dy_dialog_quick_login_account = (TextView)view.findViewById(ResourceUtil.getId((Context)this.context, "dy_dialog_quick_login_account"));
        this.mHandler = new Handler();
        this.userInfoBean = DouYou.getInstance().getUser().get(0);
        if (!this.userInfoBean.getUsername().isEmpty() && !this.userInfoBean.getPassword().isEmpty()) {
            this.dy_dialog_quick_login_account.setText((CharSequence)this.userInfoBean.getUsername());
            this.countDownTimer.start();
        } else {
            DouYou.getInstance().showAccountLogin((Context)DouYou.getInstance().context);
        }
        this.dy_dialog_quick_login_progress = (ProgressBar)view.findViewById(ResourceUtil.getId((Context)this.context, "dy_dialog_quick_login_progress"));
        this.dy_dialog_quick_login_text = (TextView)view.findViewById(ResourceUtil.getId((Context)this.context, "dy_dialog_quick_login_text"));
        this.dy_dialog_quick_login_switch = (TextView)view.findViewById(ResourceUtil.getId((Context)this.context, "dy_dialog_quick_login_switch"));
        this.dy_dialog_quick_login_switch.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onClick(View v) {
        if (v.getId() == ResourceUtil.getId((Context)this.context, "dy_dialog_quick_login_LL")) {
            this.countDownTimer.cancel();
            this.dismiss();
            DouYou.getInstance().context.startActivity(new Intent((Context)DouYou.getInstance().context, DouYouPointLoginActivity.class));
        } else if (v.getId() == ResourceUtil.getId((Context)this.context, "dy_dialog_quick_login_switch")) {
            this.countDownTimer.cancel();
            this.dismiss();
            DouYou.getInstance().context.startActivity(new Intent((Context)DouYou.getInstance().context, DouYouPointLoginActivity.class));
        }
    }

    private void LoginGoing(String username, final String password) {
        BaLeApi.getInstance().balelogin(username, password, new DouYouPostAsyncTask.HttpGetDataListener(){

            @Override
            public void getData(String returnData) {
                DouYouQuickLoginDialog.this.dy_dialog_quick_login_switch.setVisibility(8);
                DouYouQuickLoginDialog.this.dy_dialog_quick_login_progress.setVisibility(8);
                DouYouQuickLoginDialog.this.dy_dialog_quick_login_text.setText((CharSequence)"\u767b\u5f55\u6210\u529f");
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    JSONObject member_info = new JSONObject(objdata.optString("member_info"));
                    int uid = member_info.optInt("members_id");
                    int real = member_info.optInt("indulge_switch");
                    int is_bind_phone = member_info.optInt("phone_switch");
                    String token = member_info.optString("token");
                    SpUtil.getInstance().putInt("phone_login_habituation", 1);
                    LoginSuccessBean loginSuccessBean = new LoginSuccessBean();
                    loginSuccessBean.setMembers_id(uid);
                    loginSuccessBean.setIndulge_switch(real);
                    loginSuccessBean.setIs_bind_phone(is_bind_phone);
                    loginSuccessBean.setToken(token);
                    loginSuccessBean.setUser_name(member_info.optString("user_name"));
                    loginSuccessBean.setPassword(password);
                    DouYou.getInstance().loginSuccessBean = loginSuccessBean;
                    if (DouYou.getInstance().loginSuccessBean.getIndulge_switch() == 1 && DouYou.getInstance().authStatus > 0) {
                        DouYou.getInstance().showRealNameAuth((Context)DouYouQuickLoginDialog.this.context);
                    } else {
                        DouYouManage.getInstance().enterBefore();
                    }
                    DouYou.getInstance().removeUserByAccount(member_info.optString("user_name"));
                    UserInfoBean userInfoBean = new UserInfoBean();
                    userInfoBean.setUsername(member_info.optString("user_name"));
                    userInfoBean.setPassword(password);
                    DouYou.getInstance().setUser(userInfoBean);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DouYouQuickLoginDialog.this.dismiss();
                        }
                    }, 1000L);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    DouYouQuickLoginDialog.this.startActivity(new Intent((Context)DouYouQuickLoginDialog.this.context, DouYouPointLoginActivity.class));
                    DouYouQuickLoginDialog.this.dismiss();
                }
            }

            @Override
            public void Fail(String error) {
                Toast.makeText((Context)DouYouQuickLoginDialog.this.context, (CharSequence)error, (int)0).show();
                DouYouQuickLoginDialog.this.dismiss();
                DouYouQuickLoginDialog.this.startActivity(new Intent((Context)DouYouQuickLoginDialog.this.context, DouYouPointLoginActivity.class));
            }
        });
    }
}

